/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFBarcodeDetails;
import org.cip4.jdflib.resource.process.JDFExtraValues;
import org.cip4.jdflib.resource.process.JDFMetadataMap;

public abstract class JDFAutoIdentificationField
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[12];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoIdentificationField(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoIdentificationField(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoIdentificationField(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoIdentificationField[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Parameter);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Parameter;
    }

    public void setEncoding(EnumEncoding enumVar) {
        this.setAttribute("Encoding", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumEncoding getEncoding() {
        return EnumEncoding.getEnum(this.getAttribute("Encoding", null, null));
    }

    public void setEncodingDetails(String value) {
        this.setAttribute("EncodingDetails", value, null);
    }

    public String getEncodingDetails() {
        return this.getAttribute("EncodingDetails", null, "");
    }

    public void setBoundingBox(JDFRectangle value) {
        this.setAttribute("BoundingBox", value, null);
    }

    public JDFRectangle getBoundingBox() {
        String strAttrName = this.getAttribute("BoundingBox", null, null);
        JDFRectangle nPlaceHolder = JDFRectangle.createRectangle(strAttrName);
        return nPlaceHolder;
    }

    public void setFormat(String value) {
        this.setAttribute("Format", value, null);
    }

    public String getFormat() {
        return this.getAttribute("Format", null, "");
    }

    public void setOrientation(JDFMatrix value) {
        this.setAttribute("Orientation", value, null);
    }

    public JDFMatrix getOrientation() {
        String strAttrName = this.getAttribute("Orientation", null, null);
        JDFMatrix nPlaceHolder = JDFMatrix.createMatrix(strAttrName);
        return nPlaceHolder;
    }

    public void setPage(int value) {
        this.setAttribute("Page", value, (String)null);
    }

    public int getPage() {
        return this.getIntAttribute("Page", null, 0);
    }

    public void setPosition(EnumPosition enumVar) {
        this.setAttribute("Position", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumPosition getPosition() {
        return EnumPosition.getEnum(this.getAttribute("Position", null, null));
    }

    public void setPurpose(EnumPurpose enumVar) {
        this.setAttribute("Purpose", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumPurpose getPurpose() {
        return EnumPurpose.getEnum(this.getAttribute("Purpose", null, null));
    }

    public void setPurposeDetails(String value) {
        this.setAttribute("PurposeDetails", value, null);
    }

    public String getPurposeDetails() {
        return this.getAttribute("PurposeDetails", null, "");
    }

    public void setValue(String value) {
        this.setAttribute("Value", value, null);
    }

    public String getValue() {
        return this.getAttribute("Value", null, "");
    }

    public void setValueFormat(String value) {
        this.setAttribute("ValueFormat", value, null);
    }

    public String getValueFormat() {
        return this.getAttribute("ValueFormat", null, "");
    }

    public void setValueTemplate(String value) {
        this.setAttribute("ValueTemplate", value, null);
    }

    public String getValueTemplate() {
        return this.getAttribute("ValueTemplate", null, "");
    }

    public JDFBarcodeDetails getBarcodeDetails() {
        return (JDFBarcodeDetails)this.getElement("BarcodeDetails", null, 0);
    }

    public JDFBarcodeDetails getCreateBarcodeDetails() {
        return (JDFBarcodeDetails)this.getCreateElement_KElement("BarcodeDetails", null, 0);
    }

    public JDFBarcodeDetails appendBarcodeDetails() throws JDFException {
        return (JDFBarcodeDetails)this.appendElementN("BarcodeDetails", 1, null);
    }

    public JDFExtraValues getExtraValues() {
        return (JDFExtraValues)this.getElement("ExtraValues", null, 0);
    }

    public JDFExtraValues getCreateExtraValues() {
        return (JDFExtraValues)this.getCreateElement_KElement("ExtraValues", null, 0);
    }

    public JDFExtraValues appendExtraValues() throws JDFException {
        return (JDFExtraValues)this.appendElementN("ExtraValues", 1, null);
    }

    public JDFMetadataMap getCreateMetadataMap(int iSkip) {
        return (JDFMetadataMap)this.getCreateElement_KElement("MetadataMap", null, iSkip);
    }

    public JDFMetadataMap getMetadataMap(int iSkip) {
        return (JDFMetadataMap)this.getElement("MetadataMap", null, iSkip);
    }

    public Collection<JDFMetadataMap> getAllMetadataMap() {
        VElement vc = this.getChildElementVector("MetadataMap", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFMetadataMap> v = new Vector<JDFMetadataMap>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFMetadataMap)vc.get(i));
        }
        return v;
    }

    public JDFMetadataMap appendMetadataMap() {
        return (JDFMetadataMap)this.appendElement("MetadataMap", null);
    }

    static {
        JDFAutoIdentificationField.atrInfoTable[0] = new AtrInfoTable("Encoding", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumEncoding.getEnum(0), null);
        JDFAutoIdentificationField.atrInfoTable[1] = new AtrInfoTable("EncodingDetails", 0x22222222L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoIdentificationField.atrInfoTable[2] = new AtrInfoTable("BoundingBox", 0x33333333L, AttributeInfo.EnumAttributeType.rectangle, null, null);
        JDFAutoIdentificationField.atrInfoTable[3] = new AtrInfoTable("Format", 0x33333333L, AttributeInfo.EnumAttributeType.Any, null, null);
        JDFAutoIdentificationField.atrInfoTable[4] = new AtrInfoTable("Orientation", 0x33333333L, AttributeInfo.EnumAttributeType.matrix, null, null);
        JDFAutoIdentificationField.atrInfoTable[5] = new AtrInfoTable("Page", 0x33333333L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoIdentificationField.atrInfoTable[6] = new AtrInfoTable("Position", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumPosition.getEnum(0), null);
        JDFAutoIdentificationField.atrInfoTable[7] = new AtrInfoTable("Purpose", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumPurpose.getEnum(0), null);
        JDFAutoIdentificationField.atrInfoTable[8] = new AtrInfoTable("PurposeDetails", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoIdentificationField.atrInfoTable[9] = new AtrInfoTable("Value", 0x33333331L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoIdentificationField.atrInfoTable[10] = new AtrInfoTable("ValueFormat", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoIdentificationField.atrInfoTable[11] = new AtrInfoTable("ValueTemplate", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        elemInfoTable = new ElemInfoTable[3];
        JDFAutoIdentificationField.elemInfoTable[0] = new ElemInfoTable("BarcodeDetails", 0x66666111L);
        JDFAutoIdentificationField.elemInfoTable[1] = new ElemInfoTable("ExtraValues", 0x66666111L);
        JDFAutoIdentificationField.elemInfoTable[2] = new ElemInfoTable("MetadataMap", 0x33311111L);
    }

    public static class EnumPurpose
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPurpose Verification = new EnumPurpose("Verification");
        public static final EnumPurpose Separation = new EnumPurpose("Separation");
        public static final EnumPurpose Label = new EnumPurpose("Label");

        private EnumPurpose(String name) {
            super(name, m_startValue++);
        }

        public static EnumPurpose getEnum(String enumName) {
            return (EnumPurpose)EnumPurpose.getEnum(EnumPurpose.class, (String)enumName);
        }

        public static EnumPurpose getEnum(int enumValue) {
            return (EnumPurpose)EnumPurpose.getEnum(EnumPurpose.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPurpose.getEnumMap(EnumPurpose.class);
        }

        public static List getEnumList() {
            return EnumPurpose.getEnumList(EnumPurpose.class);
        }

        public static Iterator iterator() {
            return EnumPurpose.iterator(EnumPurpose.class);
        }
    }

    public static class EnumPosition
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPosition Header = new EnumPosition("Header");
        public static final EnumPosition Trailer = new EnumPosition("Trailer");
        public static final EnumPosition Page = new EnumPosition("Page");
        public static final EnumPosition Top = new EnumPosition("Top");
        public static final EnumPosition Bottom = new EnumPosition("Bottom");
        public static final EnumPosition Left = new EnumPosition("Left");
        public static final EnumPosition Right = new EnumPosition("Right");
        public static final EnumPosition Front = new EnumPosition("Front");
        public static final EnumPosition Back = new EnumPosition("Back");
        public static final EnumPosition Any = new EnumPosition("Any");

        private EnumPosition(String name) {
            super(name, m_startValue++);
        }

        public static EnumPosition getEnum(String enumName) {
            return (EnumPosition)EnumPosition.getEnum(EnumPosition.class, (String)enumName);
        }

        public static EnumPosition getEnum(int enumValue) {
            return (EnumPosition)EnumPosition.getEnum(EnumPosition.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPosition.getEnumMap(EnumPosition.class);
        }

        public static List getEnumList() {
            return EnumPosition.getEnumList(EnumPosition.class);
        }

        public static Iterator iterator() {
            return EnumPosition.iterator(EnumPosition.class);
        }
    }

    public static class EnumEncoding
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumEncoding ASCII = new EnumEncoding("ASCII");
        public static final EnumEncoding Barcode = new EnumEncoding("Barcode");
        public static final EnumEncoding BarCode1D = new EnumEncoding("BarCode1D");
        public static final EnumEncoding BarCode2D = new EnumEncoding("BarCode2D");
        public static final EnumEncoding Braille = new EnumEncoding("Braille");
        public static final EnumEncoding RFID = new EnumEncoding("RFID");

        private EnumEncoding(String name) {
            super(name, m_startValue++);
        }

        public static EnumEncoding getEnum(String enumName) {
            return (EnumEncoding)EnumEncoding.getEnum(EnumEncoding.class, (String)enumName);
        }

        public static EnumEncoding getEnum(int enumValue) {
            return (EnumEncoding)EnumEncoding.getEnum(EnumEncoding.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumEncoding.getEnumMap(EnumEncoding.class);
        }

        public static List getEnumList() {
            return EnumEncoding.getEnumList(EnumEncoding.class);
        }

        public static Iterator iterator() {
            return EnumEncoding.iterator(EnumEncoding.class);
        }
    }
}

