/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.ifaces.IElementConverter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class URLExtractor
extends BaseElementWalker
implements IElementConverter {
    protected final File dir;
    protected final String baseURL;
    protected Set<UrlUtil.URLProtocol> protocols;
    protected final String currentURL;
    protected final Set<String> saved;
    private boolean wantLog;

    public Set<String> getSaved() {
        return this.saved;
    }

    public URLExtractor(File dumpDir, String currentURL, String baseURL) {
        super(new BaseWalkerFactory());
        this.dir = dumpDir;
        this.baseURL = baseURL;
        this.currentURL = currentURL;
        this.saved = new HashSet<String>();
        this.protocols = null;
        this.setWantLog(false);
    }

    public void setWantLog(boolean bWant) {
        this.wantLog = bWant;
    }

    public void addProtocol(UrlUtil.URLProtocol protocol) {
        if (this.protocols == null) {
            this.protocols = new HashSet<UrlUtil.URLProtocol>();
        }
        this.protocols.add(protocol);
    }

    @Override
    public KElement convert(KElement e) {
        this.walkTree(e, null);
        return e;
    }

    @Override
    public String toString() {
        return super.toString() + "\n " + this.protocols + " baseURL: " + this.baseURL + " currentURL: " + this.currentURL + " dir: " + this.dir;
    }

    public class WalkURL
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            UrlUtil.URLProtocol protocol;
            IURLSetter urlSetter = (IURLSetter)((Object)e);
            String url = StringUtil.getNonEmpty(urlSetter.getURL());
            if (url == null) {
                return e;
            }
            if (URLExtractor.this.baseURL != null && url.startsWith(URLExtractor.this.baseURL)) {
                return e;
            }
            if (URLExtractor.this.protocols != null && !URLExtractor.this.protocols.contains((Object)(protocol = UrlUtil.getProtocol(url)))) {
                return e;
            }
            boolean bOverwrite = !URLExtractor.this.saved.contains(url);
            File newFile = UrlUtil.moveToDir(urlSetter, URLExtractor.this.dir, URLExtractor.this.currentURL, bOverwrite);
            if (newFile != null) {
                if (URLExtractor.this.baseURL != null) {
                    String s = UrlUtil.isRelativeURL(url) ? url : newFile.getName();
                    s = StringUtil.escape(s, "|#%?@&=+$,;[]\\\"'<>^`\u00b4{}~", "%", 16, 2, 33, Integer.MAX_VALUE);
                    String urlWithDirectory = UrlUtil.getURLWithDirectory(URLExtractor.this.baseURL, s);
                    urlSetter.setURL(urlWithDirectory);
                }
                if (URLExtractor.this.wantLog && bOverwrite) {
                    this.log.info((Object)("copied " + url + " to " + urlSetter.getURL()));
                }
            } else if (URLExtractor.this.wantLog) {
                this.log.warn((Object)("Could not copy " + url + " to " + URLExtractor.this.dir));
            }
            URLExtractor.this.saved.add(url);
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof IURLSetter;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(URLExtractor.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return e;
        }
    }
}

