/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import java.util.Iterator;
import java.util.zip.DataFormatException;
import org.apache.commons.lang.StringUtils;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.fixversion.FixVersionImpl;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;
import org.cip4.jdflib.util.StringUtil;

public class WalkElement
extends BaseWalker {
    FixVersionImpl fixVersion = null;

    public void setParent(FixVersionImpl fixVersion) {
        this.fixVersion = fixVersion;
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFElement el = (JDFElement)e1;
        if (this.fixVersion.isZappDeprecated() && el.isDeprecated()) {
            el.deleteNode();
            return null;
        }
        JDFAttributeMap m = el.getAttributeMap();
        Iterator<String> it = m.getKeyIterator();
        AttributeInfo ai = el.getAttributeInfo();
        while (it.hasNext()) {
            String key = it.next();
            String value = m.get(key);
            this.walkSingleAttribute(el, ai, key, value);
        }
        return el;
    }

    private void walkSingleAttribute(JDFElement el, AttributeInfo ai, String key, String value) {
        if (this.fixVersion.bZappDeprecated && this.fixVersion.version.isGreater(ai.getLastVersion(key))) {
            el.removeAttribute_KElement(key, null);
        } else {
            AttributeInfo.EnumAttributeType attType = ai.getAttributeType(key);
            if (AttributeInfo.EnumAttributeType.isRange(attType)) {
                this.fixRange(el, key, value);
            } else if (AttributeInfo.EnumAttributeType.duration.equals((Object)attType)) {
                this.fixDuration(el, key, value);
            } else if (AttributeInfo.EnumAttributeType.dateTime.equals((Object)attType)) {
                this.fixDateTime(el, key, value);
            }
            if (this.fixVersion.bFixIDs && value.length() > 0 && StringUtils.isNumeric((String)value.substring(0, 1))) {
                this.fixIDs(el, ai, key, value);
            }
            if ("ICSVersions".equals(key)) {
                this.fixICSVesions(el, value);
            }
            if (this.fixVersion.bZappInvalid && attType != null && !AttributeInfo.validStringForType(value, attType, null)) {
                el.removeAttribute_KElement(key, null);
            }
        }
    }

    private void fixICSVesions(JDFElement el, String value) {
        if (!this.fixVersion.fixICSVersions) {
            return;
        }
        VString v = StringUtil.tokenize(value, null, false);
        if (v == null) {
            return;
        }
        int minor = this.fixVersion.version.getMinorVersion();
        for (int i = 0; i < v.size(); ++i) {
            String icsToken = v.get(i);
            if (!".".equals(StringUtil.substring(icsToken, -2, -1)) || !StringUtil.isInteger(StringUtil.rightStr(icsToken, 1))) continue;
            icsToken = StringUtil.leftStr(icsToken, -1) + minor;
            v.set(i, icsToken);
        }
        el.setAttribute("ICSVersions", v, null);
    }

    private void fixRange(JDFElement el, String key, String value) {
        try {
            JDFNameRangeList nrl = new JDFNameRangeList(value);
            el.setAttribute(key, nrl, null);
        }
        catch (JDFException e) {
        }
        catch (DataFormatException e) {
            // empty catch block
        }
    }

    private void fixDuration(JDFElement el, String key, String value) {
        try {
            el.setAttribute(key, new JDFDuration(value).getDurationISO());
        }
        catch (DataFormatException ex) {
            // empty catch block
        }
    }

    private void fixDateTime(JDFElement el, String key, String value) {
        try {
            el.setAttribute(key, new JDFDate(value).getDateTimeISO());
        }
        catch (DataFormatException ex) {
            // empty catch block
        }
    }

    private void fixIDs(JDFElement el, AttributeInfo ai, String key, String value) {
        AttributeInfo.EnumAttributeType atType = ai.getAttributeType(key);
        if (atType != null) {
            if (atType.equals((Object)AttributeInfo.EnumAttributeType.ID) || atType.equals((Object)AttributeInfo.EnumAttributeType.IDREF)) {
                value = "_" + value;
                el.setAttribute(key, value);
            } else if (atType.equals((Object)AttributeInfo.EnumAttributeType.IDREFS)) {
                VString vvalues = new VString(value, " ");
                for (int i = 0; i < vvalues.size(); ++i) {
                    String s = vvalues.get(i);
                    if (s.length() <= 0 || !StringUtils.isNumeric((String)s.substring(0, 1))) continue;
                    s = "_" + s;
                    vvalues.setElementAt(s, i);
                }
                el.setAttribute(key, vvalues, null);
            }
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFElement;
    }
}

