/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDF;
import org.w3c.dom.Node;

public class WalkElement
extends BaseWalker {
    protected JDFToXJDF jdfToXJDF;
    boolean bMerge = false;

    public void setParent(JDFToXJDF parent) {
        this.jdfToXJDF = parent;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        String xmlComment;
        String nsURI = jdf.getNamespaceURI();
        if ("http://www.CIP4.org/JDFSchema_1_1".equals(nsURI)) {
            nsURI = XJDF20.getSchemaURL();
        }
        String nodeName = this.getXJDFName(jdf);
        KElement eNew = this.bMerge ? xjdf : xjdf.appendElement(nodeName, nsURI);
        this.setAttributes(jdf, eNew);
        eNew.setText(jdf.getText());
        Node before = null;
        int i = 0;
        while ((xmlComment = jdf.getXMLComment(i)) != null) {
            Node comment = eNew.appendXMLComment(xmlComment, null);
            if (before == null) {
                before = comment.getNextSibling();
            } else {
                eNew.insertBefore(comment, before);
            }
            ++i;
        }
        this.removeUnused(eNew);
        return eNew;
    }

    protected String getXJDFName(KElement jdf) {
        return jdf.getNodeName();
    }

    protected void setAttributes(KElement jdf, KElement eNew) {
        JDFAttributeMap map;
        JDFAttributeMap jDFAttributeMap = map = jdf instanceof JDFElement ? this.convertRanges((JDFElement)jdf) : jdf.getAttributeMap();
        if (map != null) {
            for (String key : map.keySet()) {
                String uri;
                String prefix = KElement.xmlnsPrefix(key);
                if (prefix == null || (uri = eNew.getNamespaceURIFromPrefix(prefix)) != null || (uri = jdf.getNamespaceURIFromPrefix(prefix)) == null) continue;
                eNew.addNameSpace(prefix, uri);
            }
        }
        eNew.setAttributes(map);
    }

    private JDFAttributeMap convertRanges(JDFElement jdf) {
        JDFAttributeMap map = jdf.getAttributeMap();
        if (this.jdfToXJDF.isConvertTilde()) {
            VString keys = map.getKeys();
            for (String key : keys) {
                JDFNameRangeList rl;
                if (!AttributeInfo.EnumAttributeType.isRange(jdf.getAtrType(key)) || (rl = JDFNameRangeList.createNameRangeList(map.get(key))) == null) continue;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < rl.size(); ++i) {
                    JDFNameRange r = (JDFNameRange)rl.at(i);
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append(r.getLeft());
                    buf.append(" ");
                    buf.append(r.getRight());
                }
                map.put(key, buf.toString());
            }
        }
        return map;
    }

    protected void removeUnused(KElement newRootP) {
        newRootP.removeAttribute("xsi:type");
    }
}

