/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.JDFToXJDF;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;

public class WalkJDFElement
extends WalkElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFElement je = (JDFElement)jdf;
        this.makeRefElements(je);
        return super.walk(jdf, xjdf);
    }

    private void makeRefElements(JDFElement je) {
        VElement v = je.getChildElementVector_KElement(null, null, null, true, 0);
        for (KElement e : v) {
            JDFResource r;
            if (!(e instanceof JDFResource) || this.mustInline((r = (JDFResource)e).getLocalName())) continue;
            this.cleanRefs(je, r);
        }
    }

    protected boolean matchesRootID(JDFNode node) {
        boolean matchesID = node.getID().equals(this.jdfToXJDF.rootID);
        if (!matchesID && !this.jdfToXJDF.isSingleNode()) {
            for (JDFNode parent = node.getParentJDF(); parent != null && !matchesID; parent = parent.getParentJDF()) {
                matchesID = parent.getID().equals(this.jdfToXJDF.rootID);
            }
        }
        return matchesID;
    }

    private void cleanRefs(JDFElement je, JDFResource r) {
        JDFNode parentJDF = je.getParentJDF();
        if (parentJDF != null) {
            r = r.makeRootResource(null, parentJDF, false);
            r.setResStatus(JDFResource.EnumResStatus.Available, true);
            JDFResourcePool prevPool = parentJDF.getResourcePool();
            if (prevPool != null) {
                r = this.removeDuplicateRefs(r, prevPool);
            }
            je.refElement(r);
        } else if (je.getJMFRoot() != null) {
            JDFResource resourceRoot = r.getResourceRoot();
            JDFElement parent = (JDFElement)(resourceRoot == null ? null : resourceRoot.getParentNode_KElement());
            r = r.makeRootResource(null, parent, false);
            r.setResStatus(JDFResource.EnumResStatus.Available, true);
            je.refElement(r);
        }
    }

    private JDFResource removeDuplicateRefs(JDFResource r, JDFResourcePool prevPool) {
        JDFAttributeMap m = r.getAttributeMap();
        m.remove("ID");
        VElement prevs = prevPool.getChildrenByTagName(this.jdfToXJDF.getSetName(r), null, m, true, true, 0);
        if (prevs != null) {
            for (KElement e : prevs) {
                JDFResource prev = (JDFResource)e;
                if (r == prev) continue;
                String pid = prev.getID();
                String rid = r.getID();
                prev.removeAttribute("ID");
                r.removeAttribute("ID");
                if (r.isEqual(prev)) {
                    r.deleteNode();
                    r = prev;
                    prev.setID(pid);
                    break;
                }
                r.setID(rid);
                prev.setID(pid);
            }
        }
        return r;
    }

    protected String getRefName(JDFRefElement re) {
        String name = re.getLocalName();
        if (this.jdfToXJDF.isMergeRunList() && "LayoutElementRef".equals(name)) {
            name = "RunListRef";
        }
        return name;
    }

    protected boolean mustInline(JDFRefElement re) {
        return this.mustInline(re.getRefLocalName());
    }

    protected boolean mustInline(String refLocalName) {
        return this.jdfToXJDF.inlineSet.contains(refLocalName);
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFElement;
    }

    @Override
    protected void removeUnused(KElement newRootP) {
        newRootP.removeAttribute("SpawnID");
        super.removeUnused(newRootP);
    }

    protected VElement setResource(JDFElement rl, JDFResource linkTarget, KElement xRoot) {
        String className = this.jdfToXJDF.getClassName(linkTarget);
        if (className == null || xRoot == null) {
            return null;
        }
        linkTarget.expand(false);
        String resID = linkTarget.getID();
        KElement resourceSet = xRoot.getChildWithAttribute(className + "Set", "ID", null, resID, 0, true);
        if (resourceSet == null) {
            resourceSet = xRoot.appendElement(className + "Set");
            resourceSet.setID(linkTarget.getID());
        }
        this.setSetAttributes(resourceSet, rl, linkTarget);
        int nLeaves = resourceSet.numChildElements(className, null);
        VElement vRes = rl instanceof JDFResourceLink ? ((JDFResourceLink)rl).getTargetVector(0) : linkTarget.getLeaves(false);
        VElement v = new VElement();
        for (KElement e : vRes) {
            JDFResource r = (JDFResource)e;
            VElement vLeaves = r.getLeaves(false);
            for (KElement eLeaf : vLeaves) {
                JDFResource leaf = (JDFResource)eLeaf;
                KElement newBaseRes = this.setBaseResource(rl, leaf, resourceSet);
                int nn = resourceSet.numChildElements(className, null);
                if (nn > nLeaves) {
                    nLeaves = nn;
                    this.jdfToXJDF.walkTree(leaf, newBaseRes);
                }
                v.add(newBaseRes);
            }
        }
        return v;
    }

    protected KElement setBaseResource(JDFElement rl, JDFResource r, KElement xjdfSet) {
        JDFAttributeMap map = r.getPartMap();
        SetHelper sh = new SetHelper(xjdfSet);
        KElement newLeaf = sh.getCreatePartition(map, false).getPartition();
        this.setLeafAttributes(r, rl, newLeaf);
        return newLeaf;
    }

    protected void setLeafAttributes(JDFResource leaf, JDFElement rl, KElement newLeaf) {
        JDFAttributeMap partMap = leaf.getPartMap();
        this.setAmountPool(rl, newLeaf, partMap);
        if (this.jdfToXJDF.bRetainSpawnInfo && leaf.hasAttribute("SpawnIDs")) {
            KElement spawnInfo = newLeaf.getDocRoot().getCreateElement(this.jdfToXJDF.m_spawnInfo, null, 0);
            KElement spawnID = spawnInfo.appendElement("SpawnID");
            spawnID.moveAttribute("SpawnIDs", newLeaf, null, null, null);
            spawnID.moveAttribute("SpawnStatus", newLeaf, null, null, null);
            spawnID.copyAttribute("ResourceID", newLeaf, "ID", null, null);
        }
    }

    protected void setAmountPool(JDFElement rl, KElement newLeaf, JDFAttributeMap partMap) {
        block5: {
            JDFAmountPool ap;
            block4: {
                if (rl == null) {
                    return;
                }
                ap = (JDFAmountPool)rl.getElement("AmountPool");
                if (ap != null) break block4;
                JDFAttributeMap amounts = rl.getAttributeMap().reduceMap(JDFToXJDF.amountAttribs);
                if (amounts.size() <= 0) break block5;
                ap = (JDFAmountPool)newLeaf.getCreateElement("AmountPool");
                for (String key : amounts.keySet()) {
                    ap.setPartAttribute(key, amounts.get(key), null, partMap);
                    rl.removeAttribute(key);
                }
                break block5;
            }
            VElement vPartAmounts = ap.getMatchingPartAmountVector(partMap);
            if (vPartAmounts != null && vPartAmounts.size() > 0) {
                ap = (JDFAmountPool)newLeaf.getCreateElement("AmountPool");
                for (KElement e : vPartAmounts) {
                    JDFPartAmount pa = (JDFPartAmount)e;
                    JDFPartAmount paNew = ap.getCreatePartAmount(pa.getPartMapVector());
                    paNew.setAttributes(pa);
                }
            }
        }
    }

    protected void setSetAttributes(KElement resourceSet, KElement rl, JDFResource linkRoot) {
        resourceSet.setAttribute("Name", this.jdfToXJDF.getSetName(linkRoot));
        resourceSet.setAttributes(rl);
        resourceSet.removeAttribute("rRef");
        resourceSet.removeAttribute("rSubRef");
        resourceSet.removeAttribute("Amount");
        resourceSet.removeAttribute("AmountProduced");
        resourceSet.removeAttribute("MaxAmount");
        resourceSet.removeAttribute("ActualAmount");
        if (rl instanceof JDFResourceLink) {
            VElement vCreators;
            JDFResource resInRoot;
            JDFResourceLink resLink = (JDFResourceLink)rl;
            JDFNode rootIn = resLink.getJDFRoot();
            JDFResource jDFResource = resInRoot = rootIn == null ? linkRoot : (JDFResource)rootIn.getChildWithAttribute(null, "ID", null, resLink.getrRef(), 0, false);
            if (resInRoot != null && (vCreators = resInRoot.getCreator(JDFResourceLink.EnumUsage.Input.equals((Object)resLink.getUsage()))) != null) {
                int size = vCreators.size();
                for (int i = 0; i < size; ++i) {
                    JDFNode depNode = (JDFNode)vCreators.elementAt(i);
                    KElement dependent = resourceSet.appendElement("Dependent");
                    dependent.setAttribute("JobID", depNode.getJobID(true));
                    dependent.copyAttribute("JMFURL", depNode, null, null, null);
                    dependent.copyAttribute("JobPartID", depNode, null, null, null);
                }
            }
        }
    }
}

