/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.resource.JDFResource;

public class WalkResource
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFResource r = (JDFResource)jdf;
        KElement newResLeaf = super.walk(jdf, xjdf);
        if (newResLeaf != null) {
            newResLeaf.removeAttribute("ID");
            this.moveAttribsToBase(xjdf, newResLeaf);
            this.removeDeprecatedResourceAttribs(r, newResLeaf);
            this.removeDeprecatedResourceAttribs(r, xjdf);
        }
        return newResLeaf;
    }

    protected void moveAttribsToBase(KElement xjdf, KElement newResLeaf) {
        String localName = xjdf.getLocalName();
        boolean bRoot = "Intent".equals(localName) || "Parameter".equals(localName) || "Resource".equals(localName);
        for (String attrib : this.jdfToXJDF.resAttribs) {
            if (!newResLeaf.hasAttribute(attrib)) continue;
            if (bRoot) {
                xjdf.moveAttribute(attrib, newResLeaf, null, null, null);
                continue;
            }
            newResLeaf.removeAttribute(attrib);
        }
    }

    private void removeDeprecatedResourceAttribs(JDFResource r, KElement newResLeaf) {
        newResLeaf.removeAttributes(r.getPartIDKeys());
        newResLeaf.removeAttribute("Class");
        newResLeaf.removeAttribute("PartUsage");
        newResLeaf.removeAttribute("Locked");
        newResLeaf.removeAttribute("NoOp");
        newResLeaf.removeAttribute("SpawnStatus");
        newResLeaf.removeAttribute("SpawnIDs");
        newResLeaf.removeAttribute("PartIDKeys");
    }

    protected String getClassName(JDFResource r) {
        String className;
        KElement r2;
        if (r == null) {
            return null;
        }
        JDFResource.EnumResourceClass resourceClass = r.getResourceClass();
        if (resourceClass == null && (r2 = new JDFDoc(r.getLocalName()).getRoot()) instanceof JDFResource) {
            r2.init();
            resourceClass = ((JDFResource)r2).getResourceClass();
        }
        String string = className = this.jdfToXJDF.isParameterSet() ? "Parameter" : "Resource";
        if (resourceClass == null) {
            return className;
        }
        if (resourceClass.equals((Object)JDFResource.EnumResourceClass.Intent)) {
            className = resourceClass.getName();
        } else {
            if (resourceClass.equals((Object)JDFResource.EnumResourceClass.PlaceHolder)) {
                return null;
            }
            if (!JDFResource.EnumResourceClass.Parameter.equals((Object)resourceClass)) {
                return "Resource";
            }
        }
        return className;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFResource;
    }

    protected boolean isProductResource(JDFResource linkTarget) {
        return JDFResource.EnumResourceClass.Intent.equals((Object)linkTarget.getResourceClass());
    }
}

