/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Iterator;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkStrippingParams;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.util.StringUtil;

public class WalkLayout
extends WalkStrippingParams {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFLayout;
    }

    private void splitLayout(KElement e, KElement trackElem) {
        JDFStrippingParams stripParams = (JDFStrippingParams)e.appendElement("StrippingParams");
        boolean foundSome = this.moveToStripping(e, stripParams);
        if (foundSome) {
            this.createStrippingPartition(stripParams, (JDFLayout)trackElem);
        }
        stripParams.deleteNode();
    }

    private boolean moveToStripping(KElement e, JDFStrippingParams stripParams) {
        VString vAtt = stripParams.knownAttributes();
        JDFAttributeMap map = e.getAttributeMap();
        Iterator<String> it = map.getKeyIterator();
        boolean foundSome = false;
        while (it.hasNext()) {
            String s = it.next();
            if (!vAtt.contains(s)) continue;
            stripParams.setAttribute(s, map.get(s));
            e.removeAttribute(s);
            foundSome = true;
        }
        VString stripKnown = stripParams.knownElements();
        VElement vMyElm = e.getChildElementVector_KElement(null, null, null, true, 0);
        for (KElement myElm : vMyElm) {
            String localName = myElm.getLocalName();
            if (!stripKnown.contains(localName) && (!localName.endsWith("Ref") || !stripKnown.contains(StringUtil.leftStr(localName, -3)))) continue;
            stripParams.moveElement(myElm, null);
            foundSome = true;
        }
        return foundSome;
    }

    private void createStrippingPartition(JDFStrippingParams stripParams, JDFLayout trackLayout) {
        JDFNode node = this.xjdfToJDFImpl.currentJDFNode;
        if (node == null) {
            this.log.error((Object)"whazzup - not in xjdf root???");
        } else {
            JDFAttributeMap partMap = trackLayout.getPartMap();
            JDFStrippingParams sp = (JDFStrippingParams)node.getCreateResource("StrippingParams", JDFResourceLink.EnumUsage.Input, 0);
            JDFStrippingParams part = (JDFStrippingParams)sp.getCreatePartition(partMap, trackLayout.getPartIDKeys());
            KElement foo = part.appendElement("foo");
            this.xjdfToJDFImpl.walkTree(stripParams, foo);
            KElement tmpStripParams = foo.getElement("StrippingParams");
            tmpStripParams.removeAttribute("Class");
            tmpStripParams.removeAttribute("ID");
            part.copyInto(tmpStripParams, false);
            foo.deleteNode();
        }
    }

    @Override
    public KElement walk(KElement xjdfLayout, KElement jdfLayout) {
        this.splitLayout(xjdfLayout, jdfLayout);
        KElement walk = super.walk(xjdfLayout, jdfLayout);
        return walk;
    }

    @Override
    protected String getRefName(String val) {
        if ("PaperRef".equals(val) || "PlateRef".equals(val) || "ProofRef".equals(val)) {
            return "MediaRef";
        }
        return super.getRefName(val);
    }
}

