/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoBasicPreflightTest;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFTerm;
import org.cip4.jdflib.util.StringUtil;

public class JDFIntegerState
extends JDFAbstractState {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[11];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFIntegerState(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFIntegerState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFIntegerState(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFIntegerState[ --> " + super.toString() + " ]";
    }

    public void setDefaultValue(int value) {
        this.setAttribute("DefaultValue", value, (String)null);
    }

    public void setDefaultValue(JDFIntegerList value) {
        this.setAttribute("DefaultValue", value, null);
    }

    public void setCurrentValue(JDFIntegerList value) {
        this.setAttribute("CurrentValue", value, null);
    }

    public JDFIntegerList getDefaultValue() {
        return this.getIntegerList("DefaultValue");
    }

    public void setCurrentValue(int value) {
        this.setAttribute("CurrentValue", value, (String)null);
    }

    public JDFIntegerList getCurrentValue() {
        return this.getIntegerList("CurrentValue");
    }

    public void setAllowedValueList(JDFIntegerRangeList value) {
        this.setAttribute("AllowedValueList", value.toString(), null);
    }

    public JDFIntegerRangeList getAllowedValueList() {
        return this.getIntegerRangeList("AllowedValueList");
    }

    public void setPresentValueList(JDFIntegerRangeList value) {
        this.setAttribute("PresentValueList", value.toString(), null);
    }

    public JDFIntegerRangeList getPresentValueList() {
        JDFIntegerRangeList il = this.getIntegerRangeList("PresentValueList");
        return il == null ? this.getAllowedValueList() : il;
    }

    private JDFIntegerRangeList getIntegerRangeList(String listName) {
        try {
            String attribute = this.getAttribute(listName, null, null);
            if (attribute == null) {
                return null;
            }
            return new JDFIntegerRangeList(attribute);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFIntegerState.getIntegerRangeList, Unable to create JDFIntegerRangeList from Attribute value: " + listName);
        }
    }

    private JDFIntegerList getIntegerList(String listName) {
        try {
            String attribute = this.getAttribute(listName, null, null);
            if (attribute == null) {
                return null;
            }
            return new JDFIntegerList(attribute);
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFIntegerState.getIntegerList, Unable to create JDFIntegerRangeList from Attribute value: " + listName);
        }
    }

    public void setAllowedValueMax(int value) {
        this.setAttribute("AllowedValueMax", value, (String)null);
    }

    public int getAllowedValueMax() {
        return this.getIntAttribute("AllowedValueMax", null, 0);
    }

    public void setPresentValueMax(int value) {
        this.setAttribute("PresentValueMax", value, (String)null);
    }

    public int getPresentValueMax() {
        if (this.hasAttribute("PresentValueMax")) {
            return this.getIntAttribute("PresentValueMax", null, 0);
        }
        return this.getAllowedValueMax();
    }

    public void setAllowedValueMin(int value) {
        this.setAttribute("AllowedValueMin", value, (String)null);
    }

    public int getAllowedValueMin() {
        return this.getIntAttribute("AllowedValueMin", null, 0);
    }

    public void setPresentValueMin(int value) {
        this.setAttribute("PresentValueMin", value, (String)null);
    }

    public int getPresentValueMin() {
        if (this.hasAttribute("PresentValueMin")) {
            return this.getIntAttribute("PresentValueMin", null, 0);
        }
        return this.getAllowedValueMin();
    }

    public void setAllowedValueMod(JDFXYPair value) {
        this.setAttribute("AllowedValueMod", value.toString());
    }

    public JDFXYPair getAllowedValueMod() {
        try {
            return new JDFXYPair(this.getAttribute("AllowedValueMod"));
        }
        catch (DataFormatException e) {
            throw new JDFException("JDFIntegerState.getAllowedValueMod: The XYPair value is invalid!");
        }
    }

    public void setPresentValueMod(JDFXYPair value) {
        this.setAttribute("PresentValueMod", value.toString());
    }

    public JDFXYPair getPresentValueMod() {
        try {
            if (this.hasAttribute("PresentValueMod")) {
                return new JDFXYPair(this.getAttribute("PresentValueMod"));
            }
            return this.getAllowedValueMod();
        }
        catch (DataFormatException e) {
            throw new JDFException("The XYPair value is invalid!");
        }
    }

    public String getUnitType() {
        return this.getAttribute("UnitType");
    }

    public void setUnitType(String value) {
        this.setAttribute("UnitType", value);
    }

    @Override
    public void addValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        JDFIntegerRangeList list;
        if (this.fitsValue(value, testlists)) {
            return;
        }
        if (!StringUtil.isInteger(value)) {
            return;
        }
        int i = StringUtil.parseInt(value, 0);
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Allowed.equals((Object)testlists)) {
            list = this.getAllowedValueList();
            if (list == null) {
                list = new JDFIntegerRangeList();
            }
            list.append(i);
            list.normalize(true);
            this.setAllowedValueList(list);
        }
        if (testlists == null || JDFBaseDataTypes.EnumFitsValue.Present.equals((Object)testlists)) {
            list = this.getPresentValueList();
            if (list == null || !this.hasAttribute("PresentValueList")) {
                list = new JDFIntegerRangeList();
            }
            list.append(i);
            list.normalize(true);
            this.setPresentValueList(list);
        }
    }

    @Override
    public boolean fitsValue(String value, JDFBaseDataTypes.EnumFitsValue testlists) {
        boolean testResult = true;
        if (!this.fitsListType(value)) {
            testResult = false;
        } else {
            JDFIntegerRangeList rangelist = null;
            try {
                rangelist = new JDFIntegerRangeList(value);
            }
            catch (DataFormatException dfe) {
                testResult = false;
            }
            if (testResult) {
                testResult = this.fitsValueList(rangelist, testlists) && this.fitsValueMod(rangelist, testlists);
            }
        }
        return testResult;
    }

    private final boolean fitsValueList(JDFIntegerRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuelist) {
        JDFIntegerRangeList list = null;
        list = valuelist.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueList() : this.getPresentValueList();
        if (list == null) {
            return true;
        }
        JDFAutoBasicPreflightTest.EnumListType listType = this.getListType();
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteList)) {
            return this.fitsCompleteList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.CompleteOrderedList)) {
            return this.fitsCompleteOrderedList(rangelist, list);
        }
        if (listType.equals((Object)JDFAutoBasicPreflightTest.EnumListType.ContainedList)) {
            return this.fitsContainedList(rangelist, list);
        }
        int siz = rangelist.size();
        for (int i = 0; i < siz; ++i) {
            JDFIntegerRange range = (JDFIntegerRange)rangelist.at(i);
            int lastInList = ((JDFIntegerRange)list.at(list.size() - 1)).getRight();
            int leftInRange = range.getLeft();
            int rightInRange = range.getRight();
            if (lastInList > 0 && (rightInRange < 0 && Math.abs(rightInRange) < lastInList || leftInRange < 0 && Math.abs(leftInRange) < lastInList)) {
                range.setDef(lastInList);
            }
            if (list.isPartOfRange(range)) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsValueMod(JDFIntegerRangeList rangelist, JDFBaseDataTypes.EnumFitsValue valuemod) {
        if (valuemod.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? !this.hasAttribute("AllowedValueMod") : !this.hasAttribute("AllowedValueMod") && !this.hasAttribute("PresentValueMod")) {
            return true;
        }
        JDFXYPair mod = valuemod.equals((Object)JDFBaseDataTypes.EnumFitsValue.Allowed) ? this.getAllowedValueMod() : this.getPresentValueMod();
        int divi = (int)(mod.getX() + 0.5);
        int shift = (int)(mod.getY() + 0.5);
        if (divi == 0) {
            return false;
        }
        JDFIntegerList v = rangelist.getIntegerList();
        int[] vi = v.getIntArray();
        int siz = vi.length;
        for (int i = 0; i < siz; ++i) {
            if ((vi[i] % divi - shift) % divi == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteList(JDFIntegerRangeList value, JDFIntegerRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        JDFIntegerRangeList valueList = new JDFIntegerRangeList(value);
        for (int i = l_size - 1; i >= 0; --i) {
            boolean bFound = false;
            for (int j = valueList.size() - 1; j >= 0; --j) {
                if (!list.at(i).equals(valueList.at(j))) continue;
                valueList.erase(j);
                bFound = true;
                break;
            }
            if (bFound) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsCompleteOrderedList(JDFIntegerRangeList value, JDFIntegerRangeList list) {
        int l_size;
        int v_size = value.size();
        if (v_size != (l_size = list.size())) {
            return false;
        }
        if (!value.isUnique()) {
            return false;
        }
        for (int i = 0; i < l_size; ++i) {
            if (list.at(i).equals(value.at(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean fitsContainedList(JDFIntegerRangeList value, JDFIntegerRangeList list) {
        int v_size = value.size();
        int l_size = list.size();
        for (int i = 0; i < v_size; ++i) {
            for (int j = 0; j < l_size; ++j) {
                if (!value.at(i).equals(list.at(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public VString getInvalidAttributes(JDFElement.EnumValidationLevel level, boolean bIgnorePrivate, int nMax) {
        return this.getInvalidAttributesImpl(level, bIgnorePrivate, nMax);
    }

    @Override
    public JDFTerm.EnumTerm getEvaluationType() {
        return JDFTerm.EnumTerm.IntegerEvaluation;
    }

    static {
        JDFIntegerState.atrInfoTable[0] = new AtrInfoTable("AllowedValueList", 0x33333331L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFIntegerState.atrInfoTable[1] = new AtrInfoTable("AllowedValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFIntegerState.atrInfoTable[2] = new AtrInfoTable("AllowedValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFIntegerState.atrInfoTable[3] = new AtrInfoTable("AllowedValueMod", 0x33333311L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFIntegerState.atrInfoTable[4] = new AtrInfoTable("CurrentValue", 0x33333331L, AttributeInfo.EnumAttributeType.IntegerList, null, null);
        JDFIntegerState.atrInfoTable[5] = new AtrInfoTable("DefaultValue", 0x33333331L, AttributeInfo.EnumAttributeType.IntegerList, null, null);
        JDFIntegerState.atrInfoTable[6] = new AtrInfoTable("PresentValueList", 0x33333331L, AttributeInfo.EnumAttributeType.IntegerRangeList, null, null);
        JDFIntegerState.atrInfoTable[7] = new AtrInfoTable("PresentValueMax", 0x44444431L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFIntegerState.atrInfoTable[8] = new AtrInfoTable("PresentValueMin", 0x44444431L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFIntegerState.atrInfoTable[9] = new AtrInfoTable("PresentValueMod", 0x33333311L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFIntegerState.atrInfoTable[10] = new AtrInfoTable("UnitType", 0x33333311L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFIntegerState.elemInfoTable[0] = new ElemInfoTable("ValueLoc", 0x33333311L);
    }
}

