/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cip4.jdflib.util.ContainerUtil;

public class MemorySpy {
    private final List<MemoryPoolMXBean> memList = ManagementFactory.getMemoryPoolMXBeans();
    private final MemoryMXBean mainBean = ManagementFactory.getMemoryMXBean();

    public Map<String, Long> getSizeMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("heap", this.mainBean.getHeapMemoryUsage().getUsed());
        map.put("non-heap", this.mainBean.getNonHeapMemoryUsage().getUsed());
        for (MemoryPoolMXBean poolBean : this.memList) {
            map.put(poolBean.getName(), poolBean.getUsage().getUsed());
            map.put("comitted " + poolBean.getName(), poolBean.getUsage().getCommitted());
            map.put("peak " + poolBean.getName(), poolBean.getPeakUsage().getUsed());
        }
        return map;
    }

    public long getHeapUsed(MemScope scope) {
        MemoryUsage usage = this.mainBean.getHeapMemoryUsage();
        return this.getMem(usage, scope);
    }

    public long getNonHeapUsed(MemScope scope) {
        MemoryUsage usage = this.mainBean.getNonHeapMemoryUsage();
        return this.getMem(usage, scope);
    }

    public long getPermGen(MemScope scope) {
        return this.getMemFromPool("Perm Gen", scope);
    }

    private MemoryPoolMXBean getBeanFromPool(String name) {
        for (MemoryPoolMXBean poolBean : this.memList) {
            if (!name.endsWith(poolBean.getName())) continue;
            return poolBean;
        }
        return null;
    }

    private long getMem(MemoryUsage usage, MemScope scope) {
        if (MemScope.current.equals((Object)scope) || MemScope.peak.equals((Object)scope)) {
            return usage.getUsed();
        }
        if (MemScope.commit.equals((Object)scope) || MemScope.peak.equals((Object)scope)) {
            return usage.getCommitted();
        }
        if (MemScope.init.equals((Object)scope)) {
            return usage.getInit();
        }
        return -1L;
    }

    public long getMemFromPool(String name, MemScope scope) {
        MemoryPoolMXBean bean = this.getBeanFromPool(name);
        if (bean == null) {
            return -1L;
        }
        boolean peak = MemScope.peak.equals((Object)scope) || MemScope.peakCommit.equals((Object)scope);
        MemoryUsage usage = peak ? bean.getPeakUsage() : bean.getUsage();
        return this.getMem(usage, scope);
    }

    public String getSummary() {
        StringBuffer b = new StringBuffer();
        Map<String, Long> map = this.getSummaryMap();
        for (String s : map.keySet()) {
            b.append("Mem ").append(s).append(": ").append((double)(map.get(s) / 1000L) / 1000.0).append("\n");
        }
        return b.toString();
    }

    public long getCurrentMem() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    public Map<String, Long> getSummaryMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("Free", Runtime.getRuntime().freeMemory());
        map.put("Total", Runtime.getRuntime().totalMemory());
        map.put("Current", this.getHeapUsed(MemScope.current));
        return map;
    }

    public String toString() {
        Map<String, Long> sizeMap = this.getSizeMap();
        Vector<String> keys = ContainerUtil.getKeyVector(sizeMap);
        Collections.sort(keys);
        StringBuffer b = new StringBuffer("MemorySpy: \n");
        for (String key : keys) {
            b.append(key);
            b.append(" = ");
            b.append(sizeMap.get(key));
            b.append("\n");
        }
        return b.toString();
    }

    public static enum MemScope {
        current,
        peak,
        init,
        peakCommit,
        commit;

    }
}

