/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

public class ThreadUtil {
    public static boolean sleep(int millis) {
        if (millis <= 0) {
            return true;
        }
        try {
            Thread.sleep(millis);
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    public static boolean join(Thread thread, int millis) {
        if (thread == null) {
            return true;
        }
        try {
            if (millis <= 0) {
                thread.join();
            } else {
                thread.join(millis);
            }
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object mutex, int millis) {
        if (mutex == null) {
            return false;
        }
        if (millis < 0) {
            millis = 0;
        }
        try {
            Object object = mutex;
            synchronized (object) {
                mutex.wait(millis);
            }
            return true;
        }
        catch (InterruptedException x) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAll(Object mutex) {
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notify(Object mutex) {
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                mutex.notify();
            }
        }
    }

    public static abstract class WaitTimeout<a>
    implements Runnable {
        private MyMutex mutex;
        private final int waitMillis;
        private a theObject;
        private static int threadNumber = 0;
        private Thread myThread = null;
        protected String baseName;

        protected abstract a handle();

        private void setup() {
            this.baseName = "WaitThread";
        }

        public WaitTimeout(int millis) {
            this.waitMillis = millis;
            this.theObject = null;
            this.setup();
            this.mutex = new MyMutex();
            this.myThread = new Thread((Runnable)this, this.baseName + threadNumber++);
        }

        public final void start() {
            this.myThread.start();
        }

        @Override
        public final void run() {
            this.theObject = this.handle();
            ThreadUtil.notifyAll(this.mutex);
            this.mutex = null;
        }

        public final a getWaitedObject() {
            if (this.mutex != null) {
                ThreadUtil.wait(this.mutex, this.waitMillis);
                this.mutex = null;
            }
            return this.theObject;
        }
    }

    @Deprecated
    public static class MyMutex
    extends org.cip4.jdflib.util.thread.MyMutex {
    }
}

