/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.hotfolder;

import java.io.File;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFQueueSubmissionParams;
import org.cip4.jdflib.jmf.JDFResubmissionParams;
import org.cip4.jdflib.jmf.JDFReturnQueueEntryParams;
import org.cip4.jdflib.jmf.JMFBuilderFactory;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFProcessRun;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.hotfolder.HotFolderListener;
import org.cip4.jdflib.util.hotfolder.QueueHotFolderListener;

public class QueueHotFolderListenerImpl
implements HotFolderListener {
    protected final Log log = LogFactory.getLog(this.getClass());
    final QueueHotFolderListener qhfl;
    final Vector<JDFCommand> queueCommands;

    public QueueHotFolderListenerImpl(QueueHotFolderListener qhfl, JDFJMF jmf) {
        this.qhfl = qhfl;
        if (jmf == null) {
            jmf = JMFBuilderFactory.getJMFBuilder(null).buildSubmitQueueEntry(null);
        }
        this.queueCommands = jmf.getChildrenByClass(JDFCommand.class, false, 0);
    }

    @Override
    public boolean hotFile(File hotFile) {
        boolean bFound = false;
        JDFDoc jdfDoc = JDFDoc.parseFile(hotFile.getPath());
        JDFNode jdfRoot = jdfDoc == null ? null : jdfDoc.getJDFRoot();
        for (int iMessage = 0; !bFound && iMessage < this.queueCommands.size(); ++iMessage) {
            bFound = this.processSingle(jdfRoot, hotFile, iMessage);
        }
        return bFound;
    }

    public boolean processSingle(JDFNode jdfRoot, File hotFile, int iMessage) {
        String stringURL = UrlUtil.fileToUrl(hotFile, false);
        JDFDoc jmfDoc = new JDFDoc("JMF");
        JDFJMF jmfRoot = jmfDoc.getJMFRoot();
        JDFCommand queueCommand = this.getQueueCommand(iMessage);
        if (queueCommand == null) {
            return false;
        }
        JDFCommand newCommand = (JDFCommand)jmfRoot.copyElement(queueCommand, null);
        newCommand.removeAttribute("ID");
        newCommand.appendAnchor(null);
        JDFMessage.EnumType cType = newCommand.getEnumType();
        this.log.info((Object)("generating queue command# " + iMessage + " " + queueCommand.getType()));
        if (JDFMessage.EnumType.ReturnQueueEntry.equals((Object)cType)) {
            this.extractReturnParams(stringURL, newCommand, jdfRoot);
        } else if (JDFMessage.EnumType.SubmitQueueEntry.equals((Object)cType)) {
            this.extractSubmitParams(stringURL, newCommand, jdfRoot);
        } else if (JDFMessage.EnumType.SubmitQueueEntry.equals((Object)cType)) {
            this.extractResubmitParams(stringURL, newCommand, jdfRoot);
        } else {
            this.log.error((Object)("unsupported command: " + newCommand.getType()));
        }
        return this.qhfl.submitted(jmfRoot);
    }

    private JDFCommand getQueueCommand(int iMessage) {
        return this.queueCommands == null || iMessage >= this.queueCommands.size() ? null : this.queueCommands.get(iMessage);
    }

    protected void extractReturnParams(String stringURL, JDFCommand newCommand, JDFNode jdfRoot) {
        JDFReturnQueueEntryParams rqp = newCommand.getCreateReturnQueueEntryParams(0);
        rqp.setURL(stringURL);
        if (jdfRoot != null) {
            String queueEID;
            JDFAuditPool ap = jdfRoot.getCreateAuditPool();
            JDFProcessRun pr = (JDFProcessRun)ap.getAudit(-1, JDFAudit.EnumAuditType.ProcessRun, null, null);
            String string = queueEID = pr == null ? null : pr.getAttribute("QueueEntryID");
            if (!KElement.isWildCard(queueEID)) {
                rqp.setQueueEntryID(queueEID);
            }
        }
    }

    protected void extractSubmitParams(String stringURL, JDFCommand newCommand, JDFNode jdfRoot) {
        JDFQueueSubmissionParams sqp = newCommand.getCreateQueueSubmissionParams(0);
        sqp.setURL(stringURL);
        if (jdfRoot != null) {
            JDFAuditPool ap = jdfRoot.getCreateAuditPool();
            ap.createSubmitProcessRun(null);
        }
    }

    protected void extractResubmitParams(String stringURL, JDFCommand newCommand, JDFNode jdfRoot) {
        JDFResubmissionParams resubmissionParams = newCommand.getCreateResubmissionParams(0);
        resubmissionParams.setURL(stringURL);
        if (jdfRoot != null) {
            JDFAuditPool ap = jdfRoot.getCreateAuditPool();
            ap.createSubmitProcessRun(null);
            String qeid = this.getResubmitQueueEntry(jdfRoot);
            resubmissionParams.setQueueEntryID(qeid);
        }
    }

    protected String getResubmitQueueEntry(JDFNode jdfRoot) {
        String qeid = StringUtil.getNonEmpty(jdfRoot.getGeneralID("QueueEntryID", 0));
        return qeid != null ? qeid : jdfRoot.getJobID(true);
    }
}

