/**
 *
 * Copyright (c) 2001 Heidelberger Druckmaschinen AG, All Rights Reserved.
 *
 * JDFAmount.java
 *
 * Last changes
 *
 */
package org.cip4.jdflib.span;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.w3c.dom.DOMException;

public class JDFSpanColorType extends JDFEnumerationSpan
{
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor for JDFSpanColorType
	 * 
	 * @param ownerDocument
	 * @param qualifiedName
	 * @throws DOMException
	 */
	public JDFSpanColorType(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException
	{
		super(myOwnerDocument, qualifiedName);
	}

	/**
	 * Constructor for JDFSpanColorType
	 * 
	 * @param ownerDocument
	 * @param namespaceURI
	 * @param qualifiedName
	 * @throws DOMException
	 */
	public JDFSpanColorType(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName);
	}

	/**
	 * Constructor for JDFSpanColorType
	 * 
	 * @param ownerDocument
	 * @param namespaceURI
	 * @param qualifiedName
	 * @param localName
	 * @throws DOMException
	 */
	public JDFSpanColorType(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException
	{
		super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
	}

	/**
	 * Enumeration strings for EnumSpanColorType
	 */
	public static class EnumSpanColorType extends ValuedEnum
	{
		private static final long serialVersionUID = 1L;
		private static int m_startValue = 0;

		private EnumSpanColorType(String name)
		{
			super(name, m_startValue++);
		}

		public static EnumSpanColorType getEnum(String enumName)
		{
			return (EnumSpanColorType) getEnum(EnumSpanColorType.class, enumName);
		}

		public static EnumSpanColorType getEnum(int enumValue)
		{
			return (EnumSpanColorType) getEnum(EnumSpanColorType.class, enumValue);
		}

		public static Map getEnumMap()
		{
			return getEnumMap(EnumSpanColorType.class);
		}

		public static List getEnumList()
		{
			return getEnumList(EnumSpanColorType.class);
		}

		public static Iterator iterator()
		{
			return iterator(EnumSpanColorType.class);
		}

		public static final EnumSpanColorType Monochrome = new EnumSpanColorType("Monochrome");
		public static final EnumSpanColorType BasicColor = new EnumSpanColorType("BasicColor");
		public static final EnumSpanColorType MatchedColor = new EnumSpanColorType("MatchedColor");

	}

	// **************************************** Methods
	// *********************************************

	/**
	 * AllowedValues - vector of allowed values for this EnumerationSpan
	 * 
	 * @return Vector - vector representation of the allowed values
	 */
	@Override
	public ValuedEnum getEnumType()
	{
		return EnumSpanColorType.getEnum(0);
	}

	/**
	 * toString
	 * 
	 * @return String
	 */
	@Override
	public String toString()
	{
		return "JDFSpanColorType[  --> " + super.toString() + " ]";
	}
}
