/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.util.ContainerUtil;

public class SizeWalker
extends BaseElementWalker {
    HashMap<String, Sizes> map = new HashMap();
    private File outTxt = null;
    private final PrintWriter writer;

    Sizes getSize(String nam) {
        Sizes s = this.map.get(nam);
        if (s == null) {
            s = new Sizes(nam);
            this.map.put(nam, s);
        }
        return s;
    }

    public int walkAll(KElement e) {
        int n = this.walkTree(e, null);
        Vector<Sizes> v = ContainerUtil.toValueVector(this.map);
        Collections.sort(v);
        Collections.reverse(v);
        this.writer.print(v);
        this.writer.flush();
        this.writer.close();
        return n;
    }

    public SizeWalker(File xpathOutput) throws FileNotFoundException {
        super(new BaseWalkerFactory());
        this.outTxt = xpathOutput;
        this.writer = new PrintWriter(this.outTxt);
    }

    private class Sizes
    implements Comparable<Sizes> {
        int total = 0;
        int local = 0;
        int n = 0;
        String nam;

        public Sizes(String name) {
            this.nam = name;
        }

        @Override
        public int compareTo(Sizes o) {
            return this.total - o.total;
        }

        public String toString() {
            return this.nam + " N: " + this.n + " Total Size:" + this.total + " Local size:" + this.local + "\n";
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(SizeWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String nam = e.getNodeName();
            Sizes siz = SizeWalker.this.getSize(nam);
            int locSize = e.toDisplayXML(0).length();
            siz.total += locSize;
            siz.local += locSize;
            KElement parent = e.getParentNode_KElement();
            if (parent != null) {
                Sizes ps = SizeWalker.this.getSize(parent.getNodeName());
                ps.local -= locSize;
                if (siz == ps) {
                    ps.total -= locSize;
                }
            }
            ++siz.n;
            VString atts = e.getAttributeVector_KElement();
            if (atts != null) {
                for (String att : atts) {
                    Sizes as = SizeWalker.this.getSize("@" + att);
                    ++as.n;
                    String val = e.getAttribute(att);
                    int l = att.length() + val.length() + 4;
                    as.total += l;
                    as.local += val.length();
                }
            }
            return e;
        }
    }
}

