/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.ifaces.IAmountPoolContainer;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class PartitionHelper
extends BaseXJDFHelper
implements IAmountPoolContainer {
    public PartitionHelper(KElement partition) {
        this.theElement = partition;
    }

    public static boolean isAsset(KElement toCheck) {
        if (toCheck == null) {
            return false;
        }
        KElement parent = toCheck.getParentNode_KElement();
        String setName = SetHelper.getSetName(parent);
        return toCheck.getLocalName().equals(setName);
    }

    public static boolean isAsset(KElement toCheck, String resName) {
        if (PartitionHelper.isAsset(toCheck)) {
            if (StringUtil.getNonEmpty(resName) == null) {
                return true;
            }
            KElement parent = toCheck.getParentNode_KElement();
            String name = parent.getAttribute("Name");
            return name.equals(resName);
        }
        return false;
    }

    public static boolean isResourceElement(KElement toCheck) {
        if (toCheck == null) {
            return false;
        }
        KElement parent = toCheck.getParentNode_KElement();
        return PartitionHelper.isAsset(parent) && new PartitionHelper(parent).getResource() == toCheck;
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        VJDFAttributeMap vMap = new VJDFAttributeMap();
        VElement vParts = this.theElement.getChildElementVector("Part", null);
        if (vParts != null) {
            for (KElement e : vParts) {
                vMap.add(e.getAttributeMap());
            }
            if (vParts.size() == 0) {
                vMap.add(new JDFAttributeMap());
            }
        }
        return vMap;
    }

    public JDFAttributeMap getPartMap() {
        JDFPart part = (JDFPart)this.theElement.getElement("Part");
        return part == null ? new JDFAttributeMap() : part.getAttributeMap();
    }

    public void setPartMap(JDFAttributeMap map) {
        JDFPart part = (JDFPart)this.theElement.getCreateElement("Part");
        part.setAttributes(map);
    }

    public boolean matches(JDFAttributeMap map) {
        if (map == null) {
            map = new JDFAttributeMap();
        }
        return map.subMap(this.getPartMapVector());
    }

    public boolean containsMap(JDFAttributeMap map) {
        if (map == null) {
            map = new JDFAttributeMap();
        }
        VJDFAttributeMap vm = this.getPartMapVector();
        return vm.contains(map);
    }

    public boolean matches(VJDFAttributeMap vmap) {
        if (vmap == null) {
            vmap = new VJDFAttributeMap();
        }
        return vmap.subMap(this.getPartMapVector());
    }

    public KElement getPartition() {
        return this.theElement;
    }

    public SetHelper getSet() {
        KElement parent = this.theElement.getParentNode_KElement();
        if (parent != null && parent.getNodeName().equals(this.theElement.getNodeName() + "Set")) {
            return new SetHelper(parent);
        }
        return null;
    }

    public void setAmount(double amount, JDFAttributeMap moreMap, boolean bGood) {
        JDFAmountPool ap = this.getCreateAmountPool();
        JDFPartAmount pa0 = ap.getCreatePartAmount(new VJDFAttributeMap(moreMap));
        pa0.setAttribute("Amount" + (bGood ? "" : ""), StringUtil.formatDouble(amount), null);
    }

    public KElement getResource() {
        String name;
        KElement set = this.theElement.getParentNode_KElement();
        String string = name = set != null ? set.getAttribute("Name", null, null) : null;
        if (name != null) {
            return this.theElement.getElement(name);
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (e instanceof JDFPart || e instanceof JDFGeneralID || e instanceof JDFComment) continue;
            return e;
        }
        return null;
    }

    public KElement getCreateResource() {
        String name;
        KElement set = this.theElement.getParentNode_KElement();
        String string = name = set != null ? set.getAttribute("Name", null, null) : null;
        if (name != null) {
            return this.theElement.getCreateElement(name);
        }
        return null;
    }

    public String toString() {
        return "PartitionHelper: " + this.theElement;
    }

    @Override
    public void cleanUp() {
        if (!this.theElement.hasAttribute("ID")) {
            this.theElement.setID(this.theElement.generateDotID("ID", null));
        }
    }

    @Override
    public JDFAmountPool getAmountPool() {
        return (JDFAmountPool)this.getRoot().getElement("AmountPool");
    }

    @Override
    public String getAttribute(String attrib, String nameSpaceURI, String def) {
        return this.getRoot().getAttribute(attrib, nameSpaceURI, def);
    }

    @Override
    public double getRealAttribute(String attName, String namespace, double def) {
        return def;
    }

    @Override
    public boolean hasAttribute(String attName) {
        return StringUtil.getNonEmpty(this.getAttribute(attName, null, null)) != null;
    }

    @Override
    public JDFResource getLinkRoot() {
        return (JDFResource)this.getResource();
    }

    @Override
    public void setAttribute(String attrib, String value, String nameSpaceURI) {
        this.getRoot().setAttribute(attrib, value, nameSpaceURI);
    }

    @Override
    public void removeAttribute(String attrib, String nameSpaceURI) {
    }

    @Override
    public JDFAmountPool getCreateAmountPool() {
        return (JDFAmountPool)this.getRoot().getCreateElement("AmountPool");
    }
}

