/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.zip.ZipReader;

public class XJDFZipReader
implements IStreamWriter {
    final ZipReader theReader;
    JDFDoc newDoc;

    public XJDFZipReader(InputStream inStream) {
        this.theReader = ZipReader.getZipReader(inStream);
        this.theReader.setCaseSensitive(false);
        this.newDoc = null;
    }

    public XJDFZipReader(File inFile) {
        this(FileUtil.getBufferedInputStream(inFile));
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        if (this.newDoc == null) {
            this.convert();
        }
        if (this.newDoc != null) {
            this.newDoc.write2Stream(os, 2, false);
        }
    }

    public void convert() {
        if (this.theReader != null) {
            ZipEntry ze;
            XJDFToJDFConverter c = new XJDFToJDFConverter(null);
            int i = 0;
            while ((ze = this.theReader.getMatchingEntry("*.xjdf", i)) != null) {
                XMLDoc xdoc = this.theReader.getXMLDoc();
                if (xdoc != null) {
                    this.newDoc = c.convert(xdoc.getRoot());
                }
                ++i;
            }
        }
    }
}

