/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.ifaces.ICapabilityElement;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.devicecapability.JDFAbstractState;
import org.cip4.jdflib.resource.devicecapability.JDFDevCap;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.util.StringUtil;

public class WalkDevcapElement
extends WalkJDFElement {
    @Override
    public KElement walk(KElement e, KElement trackElem) {
        return trackElem;
    }

    protected String getXPathRoot(String path, String old) {
        if (path == null || "/".equals(path) || "".equals(path)) {
            return path;
        }
        String rootPath = StringUtil.replaceToken(path, -1, "/", null);
        return rootPath;
    }

    protected VString getXPathVector(JDFElement dc, String name) {
        VString v = null;
        if (dc instanceof JDFDevCap) {
            v = ((JDFDevCap)dc).getNamePathVector();
        } else if (dc instanceof JDFAbstractState) {
            v = ((JDFAbstractState)dc).getNamePathVector();
        } else if (dc instanceof JDFEvaluation) {
            ICapabilityElement refTarget = ((JDFEvaluation)dc).getRefTarget();
            v = refTarget != null ? refTarget.getNamePathVector() : null;
        }
        if (v != null && v.size() > 0) {
            VString v2 = new VString();
            for (String s : v) {
                s = this.modifyXPath(s);
                v2.add(s);
            }
            v = v2;
            v.unify();
        }
        return v;
    }

    protected String getClassName(String name) {
        if (name == null) {
            return null;
        }
        KElement e = new JDFDoc(name).getRoot();
        String className = e instanceof JDFResource ? this.jdfToXJDF.getClassName((JDFResource)e) : null;
        return className;
    }

    public String modifyXPath(String s) {
        VString vs = StringUtil.tokenize(s, "/", false);
        for (int i = vs.size() - 2; i >= 0; --i) {
            if (!vs.elementAt(i).equals(vs.elementAt(i + 1))) continue;
            vs.remove(i + 1);
        }
        int posJMF = vs.indexOf("JMF");
        while (posJMF-- > 0) {
            vs.remove(0);
        }
        if (vs.size() == 0) {
            s = "/";
        } else {
            if ("JDF".equals(vs.get(0))) {
                vs.set(0, "XJDF");
            }
            if (vs.size() > 1 && "ResourcePool".equals(vs.get(1))) {
                String name;
                String className = null;
                if (vs.size() == 3 && (className = this.getClassName(name = vs.get(2))) != null) {
                    if ("Intent".equals(className)) {
                        vs.set(1, "ProductList/Product");
                    } else {
                        vs.set(1, className + "Set/" + className);
                    }
                }
                if (className == null) {
                    vs.remove(1);
                    vs.remove(0);
                }
            }
            if (!(s = StringUtil.setvString(vs, "/", "/", null)).startsWith("/XJDF")) {
                s = "/" + s;
            }
        }
        return s;
    }

    @Override
    public boolean matches(KElement e) {
        return false;
    }
}

