/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Map;
import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDropItemIntent;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.util.StringUtil;

public class WalkProduct
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdfProduct, KElement trackElem) {
        JDFNode theNode = (JDFNode)trackElem;
        if ("Product".equals(theNode.getType())) {
            JDFNode tmp = theNode.getRoot().getChildJDFNode(xjdfProduct.getAttribute("ID"), false);
            if (tmp != null) {
                theNode = tmp;
            } else if (!this.xjdfToJDFImpl.firstproductInList) {
                theNode = theNode.addProduct();
            }
        } else {
            theNode = this.xjdfToJDFImpl.createProductRoot();
        }
        this.xjdfToJDFImpl.firstproductInList = false;
        this.copyToNode(xjdfProduct, theNode);
        JDFComponent c = this.fixComponent(theNode, xjdfProduct);
        this.updateDeliveryIntent(xjdfProduct, theNode, c);
        return theNode;
    }

    private void updateDeliveryIntent(KElement xjdfProduct, JDFNode theNode, JDFComponent c) {
        JDFResourceLink rlc = theNode.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
        double overage = rlc.getMaxAmount();
        double underage = rlc.getMinAmount();
        double amount = StringUtil.parseDouble(xjdfProduct.getAttribute("Amount", null, null), -1000.0);
        if (amount > 0.0 && (overage > 0.0 || underage > 0.0)) {
            JDFDeliveryIntent di = (JDFDeliveryIntent)theNode.getCreateResource("DeliveryIntent", JDFResourceLink.EnumUsage.Input, 0);
            if (overage > 0.0) {
                di.appendOverage().setActual(100.0 * (overage - amount) / amount);
            }
            if (underage > 0.0) {
                di.appendUnderage().setActual(100.0 * (amount - underage) / amount);
            }
            JDFDropItemIntent dropItemIntent = di.appendDropIntent().appendDropItemIntent();
            dropItemIntent.setAmount((int)amount);
            dropItemIntent.refElement(c);
        }
    }

    private void copyToNode(KElement e, JDFNode theNode) {
        VString ignore = new VString("IsRoot", null);
        theNode.setAttributes(e, ignore);
    }

    private JDFComponent fixComponent(JDFNode theNode, KElement xjdfProduct) {
        JDFComponent c = (JDFComponent)theNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (c == null) {
            JDFNode parent;
            c = (JDFComponent)theNode.addResource("Component", JDFResourceLink.EnumUsage.Output);
            Map<String, IDFinder.IDPart> map = this.xjdfToJDFImpl.idMap;
            String string = c.getID();
            IDFinder iDFinder = new IDFinder();
            iDFinder.getClass();
            map.put(string, iDFinder.new IDFinder.IDPart(c.getID(), null));
            boolean isRootProduct = new ProductHelper(xjdfProduct).isRootProduct();
            JDFAutoComponent.EnumComponentType partialFinal = isRootProduct ? JDFAutoComponent.EnumComponentType.FinalProduct : JDFAutoComponent.EnumComponentType.PartialProduct;
            c.setComponentType(partialFinal, null);
            if (!isRootProduct && (parent = theNode.getParentJDF()) != null && JDFNode.EnumType.Product.equals((Object)parent.getEnumType())) {
                parent.ensureLink(c, JDFResourceLink.EnumUsage.Input, null);
            }
        }
        AttributeInfo info = c.getAttributeInfo();
        VString cKnown = info.knownAttribs();
        AttributeInfo infoNode = theNode.getAttributeInfo();
        cKnown.removeAll(infoNode.knownAttribs());
        cKnown.remove("Amount");
        cKnown.remove("ActualAmount");
        for (String known : cKnown) {
            if (!theNode.hasAttribute(known)) continue;
            c.moveAttribute(known, theNode);
        }
        JDFResourceLink rl = theNode.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
        if (rl != null) {
            rl.moveAttribute("Amount", theNode);
            rl.moveAttribute("MinAmount", theNode);
            rl.moveAttribute("MaxAmount", theNode);
        }
        return c;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && toCheck.getLocalName().equals("Product");
    }
}

