/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.util.StringUtil;

public class WalkTypesafeMessage
extends WalkXElement {
    @Override
    public KElement walk(KElement e, KElement trackElem) {
        String messageName = e.getLocalName();
        VString families = JDFMessage.EnumFamily.getFamilies();
        for (String family : families) {
            if (!messageName.startsWith(family)) continue;
            String type = this.getMessageType(e, messageName, family);
            e.renameElement(family, null);
            e.setAttribute("Type", type);
        }
        this.fixAuthor(e);
        return super.walk(e, trackElem);
    }

    String getMessageType(KElement e, String messageName, String family) {
        String type = StringUtil.rightStr(messageName, -family.length());
        return type;
    }

    @Override
    public boolean matches(KElement toCheck) {
        if (!super.matches(toCheck)) {
            return false;
        }
        String localName = toCheck.getLocalName();
        char first = localName.charAt(0);
        if (localName.length() < 6 || "ACQSR".indexOf(first) < 0) {
            return false;
        }
        VString families = JDFMessage.EnumFamily.getFamilies();
        for (String family : families) {
            if (!localName.startsWith(family)) continue;
            return true;
        }
        return false;
    }
}

