/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.StringUtil;

public class WalkXElement
extends BaseWalker {
    protected XJDFToJDFImpl xjdfToJDFImpl = null;

    public void setParent(XJDFToJDFImpl xjdftojdf) {
        this.xjdfToJDFImpl = xjdftojdf;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        VElement v = trackElem.getChildElementVector(null, null);
        for (KElement kk : v) {
            if (!e.isEqual(kk)) continue;
            return null;
        }
        this.cleanRefs(e, trackElem);
        if (PartitionHelper.isResourceElement(e) || IntentHelper.isIntentResource(e)) {
            trackElem.setAttributes(e);
        } else {
            KElement e2 = trackElem.copyElement(e, null);
            this.xjdfToJDFImpl.convertUnits(e2);
            this.xjdfToJDFImpl.convertTilde(e2);
            this.fixNamespace(e2);
            e2.removeChildren(null, null, null);
            trackElem = e2;
        }
        this.xjdfToJDFImpl.convertUnits(trackElem);
        this.xjdfToJDFImpl.convertTilde(trackElem);
        if (trackElem instanceof JDFElement) {
            JDFAttributeMap map = trackElem.getAttributeMap_KElement();
            ((JDFElement)trackElem).init();
            trackElem.setAttributes(map);
        }
        return trackElem;
    }

    private void fixNamespace(KElement e2) {
        String namespace = e2.getNamespaceURI();
        if (JDFElement.getSchemaURL(2, 0).equals(StringUtil.leftStr(namespace, -1) + 0)) {
            e2.setNamespaceURI(JDFElement.getSchemaURL(1, 1));
            if (StringUtil.getNonEmpty(e2.getPrefix()) != null) {
                e2.setPrefix(null);
            }
        }
    }

    protected String getRefName(String val) {
        String refName = val.endsWith("Refs") ? StringUtil.leftStr(val, -1) : val;
        return refName;
    }

    protected void cleanRefs(KElement e, KElement trackElem) {
        JDFAttributeMap map = e.getAttributeMap();
        if (map == null) {
            return;
        }
        VString keys = map.getKeys();
        if (keys != null) {
            for (String key : keys) {
                if (!key.endsWith("Ref") && !key.endsWith("Refs") || key.equals("rRef")) continue;
                String values = map.get(key);
                this.cleanRef(e, trackElem, key, values);
            }
        }
    }

    protected void cleanRef(KElement e, KElement trackElem, String val, String values) {
        VString vValues = StringUtil.tokenize(values, null, false);
        for (String value : vValues) {
            IDFinder.IDPart p = this.xjdfToJDFImpl.idMap.get(value);
            if (p == null) continue;
            String refName = this.getRefName(val);
            if (refName != null) {
                KElement refOld = trackElem != null ? trackElem.getElement(refName) : null;
                KElement ref = e.appendElement(refName);
                ref.setAttribute("rRef", p.getID());
                VJDFAttributeMap vpartmap = p.getPartMap();
                if (vpartmap != null) {
                    for (int j = 0; j < vpartmap.size(); ++j) {
                        ref.appendElement("Part").setAttributes(vpartmap.get(j));
                    }
                }
                if (ref.isEqual(refOld)) {
                    ref.deleteNode();
                }
            }
            e.removeAttribute(val);
        }
    }

    protected void fixAuthor(KElement e) {
        String pID;
        String author = e.getAttribute("Author", null, null);
        if (StringUtil.getNonEmpty(author) != null) {
            e.removeAttribute("Author");
            JDFEmployee emp = (JDFEmployee)e.getCreateElement("Employee", null, 0);
            emp.setDescriptiveName(author);
        }
        if (StringUtil.getNonEmpty(pID = e.getAttribute("PersonalID", null, null)) != null) {
            e.removeAttribute("PersonalID");
            JDFEmployee emp = (JDFEmployee)e.getCreateElement("Employee", null, 0);
            emp.setPersonalID(pID);
        }
    }
}

