/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDF
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdf, KElement jdf) {
        this.xjdfToJDFImpl.currentJDFNode = (JDFNode)jdf;
        this.xjdfToJDFImpl.currentJDFNode.setAttributes(xjdf);
        this.xjdfToJDFImpl.currentJDFNode.setVersion(this.xjdfToJDFImpl.getVersion());
        this.xjdfToJDFImpl.currentJDFNode.setMaxVersion(JDFElement.EnumVersion.Version_2_0);
        this.xjdfToJDFImpl.currentJDFNode.setStatus(JDFElement.EnumNodeStatus.Part);
        this.updateJobID();
        this.setType();
        return this.xjdfToJDFImpl.currentJDFNode;
    }

    private void setType() {
        String t = this.xjdfToJDFImpl.currentJDFNode.getAttribute("Types", null, null);
        if ("Product".equals(t) || StringUtil.getNonEmpty(t) == null) {
            this.xjdfToJDFImpl.currentJDFNode.setType(JDFNode.EnumType.Product);
            this.xjdfToJDFImpl.currentJDFNode.removeAttribute("Types");
            this.xjdfToJDFImpl.foundProduct = true;
            this.xjdfToJDFImpl.createProduct = true;
        } else if (StringUtil.tokenize(t, null, false).size() == 1) {
            this.xjdfToJDFImpl.currentJDFNode.setType(t.trim(), false);
        } else {
            this.xjdfToJDFImpl.currentJDFNode.setType(JDFNode.EnumType.ProcessGroup);
        }
    }

    private void updateJobID() {
        JDFNode parentNode = this.xjdfToJDFImpl.currentJDFNode.getParentJDF();
        if (parentNode != null) {
            String jobID = StringUtil.getNonEmpty(parentNode.getJobID(true));
            String myJobID = StringUtil.getNonEmpty(this.xjdfToJDFImpl.currentJDFNode.getJobID(false));
            if (myJobID != null && myJobID.equals(jobID)) {
                this.xjdfToJDFImpl.currentJDFNode.removeAttribute("JobID");
            }
        } else {
            this.xjdfToJDFImpl.currentJDFNode.appendAnchor(null);
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && "XJDF".equals(toCheck.getLocalName());
    }
}

