/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.util.HashMap;
import java.util.Vector;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkValidatorMap;
import org.cip4.jdflib.util.ContainerUtil;

public class LinkInfoMap
extends HashMap<String, LinkInfo> {
    private static final long serialVersionUID = 1L;

    LinkInfoMap() {
    }

    LinkInfoMap(LinkInfoMap info) {
        Vector<String> keys = ContainerUtil.getKeyVector(info);
        if (keys != null) {
            for (String key : keys) {
                this.put(key, new LinkInfo((LinkInfo)info.get(key)));
            }
        }
    }

    @Override
    public LinkInfo put(String key, LinkInfo value) {
        LinkInfo old = (LinkInfo)this.get(key);
        if (old != null) {
            old.merge(value);
            return old;
        }
        return super.put(key, value);
    }

    void merge(LinkInfoMap typeLinkInfo) {
        Vector<String> resNames;
        if (typeLinkInfo != null && (resNames = ContainerUtil.getKeyVector(typeLinkInfo)) != null) {
            for (String resName : resNames) {
                LinkInfo li = (LinkInfo)this.get(resName);
                LinkInfo li2 = (LinkInfo)typeLinkInfo.get(resName);
                if (li != null && li2 != null) {
                    if (LinkValidatorMap.getLinkValidatorMap().getGenericLinkNames().contains(resName) && li.equals(li2)) continue;
                    if (li.hasOutput(null) && li2.hasInput(null)) {
                        li.makeOptional(false, true);
                        li2 = new LinkInfo(li2);
                        li2.makeOptional(true, false);
                    }
                    li.merge(li2);
                    continue;
                }
                if (li2 == null) continue;
                this.put(resName, new LinkInfo(li2));
            }
        }
    }

    public LinkInfo getStar(String key) {
        LinkInfo li = (LinkInfo)super.get(key);
        LinkInfo li2 = (LinkInfo)super.get("*");
        if (li == null) {
            if (li2 != null) {
                li = new LinkInfo(li2);
            }
        } else {
            li = new LinkInfo(li);
            li.merge(li2);
        }
        return li;
    }
}

