/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.node;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkInfoMap;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class LinkValidatorMap {
    private static LinkValidatorMap theLinkValidator = null;
    private final HashMap<String, LinkInfoMap> m_LinkInfoMap = new HashMap();
    private final String[] m_GenericLinkInfo = new String[]{"i*", "i?", "i*", "i*", "i*", "i?", "i*", "i*", "i*", "i*"};
    private final String[] m_GenericLinkNames = new String[]{"ApprovalSuccess", "CustomerInfo", "Device", "Employee", "MiscConsumable", "NodeInfo", "PreflightReport", "Preview", "Tool", "UsageCounter"};
    private HashSet<String> nameSet = null;

    public static LinkValidatorMap getLinkValidatorMap() {
        if (theLinkValidator == null) {
            theLinkValidator = new LinkValidatorMap();
        }
        return theLinkValidator;
    }

    private void mapPut(String key, String nameAddon, String linkAddon) {
        LinkInfoMap newMap = new LinkInfoMap();
        int genericPos = 0;
        for (String name : this.m_GenericLinkNames) {
            LinkInfo li = new LinkInfo(this.m_GenericLinkInfo[genericPos]);
            newMap.put(name, li);
        }
        VString vNames = StringUtil.tokenize(nameAddon, ",", false);
        VString vInfos = StringUtil.tokenize(linkAddon, ",", false);
        if (vNames != null && vInfos != null && vNames.size() == vInfos.size()) {
            int pos = 0;
            for (String name : vNames) {
                LinkInfo li = new LinkInfo(vInfos.get(pos));
                newMap.put(name, li);
                ++pos;
            }
        }
        this.m_LinkInfoMap.put(key, newMap);
    }

    private LinkValidatorMap() {
        this.initMaps();
    }

    private void initMaps() {
        this.mapPut(JDFNode.EnumType.Product.getName(), ",Component,ArtDeliveryIntent,BindingIntent,ColorIntent,DeliveryIntent,EmbossingIntent,FoldingIntent,HoleMakingIntent,InsertingIntent,LaminatingIntent,LayoutIntent,MediaIntent,NumberingIntent,PackingIntent,ProductionIntent,ProofingIntent,ScreeningIntent,ShapeCuttingIntent,SizeIntent", ",o+ i* i*Cover i?Jacket i?Parent i*EndSheet,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?,i?");
        this.mapPut("*", "", "");
        this.mapPut(JDFNode.EnumType.ProcessGroup.getName(), ",*", ",i* o*");
        this.mapPut(JDFNode.EnumType.Combined.getName(), "", "");
        this.mapPut(JDFNode.EnumType.Approval.getName(), ",*,ApprovalSuccess,ApprovalParams", ",o*Rejected o*Accepted i*,o_,i_");
        this.mapPut(JDFNode.EnumType.Buffer.getName(), ",*,BufferParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Combine.getName(), ",*", ",o_ i+");
        this.mapPut(JDFNode.EnumType.Delivery.getName(), ",*,DeliveryParams", ",o+ i?,i_");
        this.mapPut(JDFNode.EnumType.ManualLabor.getName(), ",*,ManualLaborParams", ",o* i*,i_");
        this.mapPut(JDFNode.EnumType.Ordering.getName(), ",*,OrderingParams", ",o+,i_");
        this.mapPut(JDFNode.EnumType.Packing.getName(), ",*,PackingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.QualityControl.getName(), ",*,QualityControlResult,QualityControlParams", ",o_ i_,o_,i_");
        this.mapPut(JDFNode.EnumType.ResourceDefinition.getName(), ",*,ResourceDefinitionParams", ",o+ i*,i?");
        this.mapPut(JDFNode.EnumType.Split.getName(), ",*", ",o+ i_");
        this.mapPut(JDFNode.EnumType.Verification.getName(), ",*,DBSelection,ApprovalSuccess,VerificationParams,IdentificationField,DBSchema", ",o? i?,o? i?,o?,i_,i*,i?");
        this.mapPut(JDFNode.EnumType.AssetListCreation.getName(), ",AssetListCreationParams,RunList", ",i_,i_ o_");
        this.mapPut(JDFNode.EnumType.Bending.getName(), ",BendingParams,ExposedMedia,Media", ",i_,i? o_,i?");
        this.mapPut(JDFNode.EnumType.ColorCorrection.getName(), ",ColorantControl,ColorCorrectionParams,RunList", ",i?,i_,o_ i_");
        this.mapPut(JDFNode.EnumType.ColorSpaceConversion.getName(), ",ColorantControl,ColorSpaceConversionParams,RunList", ",i?,i_,o_ i_");
        this.mapPut(JDFNode.EnumType.ContactCopying.getName(), ",ContactCopyParams,DevelopingParams,ExposedMedia,Media,PlateCopyParams", ",i_,i?,o_ i+,i_,i?");
        this.mapPut(JDFNode.EnumType.ContoneCalibration.getName(), ",RunList,ScreeningParams,TransferFunctionControl", ",o_ i_,i?,i?");
        this.mapPut(JDFNode.EnumType.CylinderLayoutPreparation.getName(), ",CylinderLayoutPreparationParams,Layout,RunList,CylinderLayout", ",i?,i_,i_,o_");
        this.mapPut(JDFNode.EnumType.DBDocTemplateLayout.getName(), ",DBRules,DBSchema,LayoutElement", ",i_,i_,o* i*");
        this.mapPut(JDFNode.EnumType.DBTemplateMerging.getName(), ",DBMergeParams,DBSelection,LayoutElement,RunList", ",i_,i_,i*,o_");
        this.mapPut(JDFNode.EnumType.DieDesign.getName(), ",DieLayout", ",i_ o+");
        this.mapPut(JDFNode.EnumType.DieLayoutProduction.getName(), ",DieLayout,DieLayoutProductionParams", ",i+ o+,i_");
        this.mapPut(JDFNode.EnumType.DigitalDelivery.getName(), ",DigitalDeliveryParams,RunList", ",i_,o+ i*");
        this.mapPut(JDFNode.EnumType.FilmToPlateCopying.getName(), ",DevelopingParams,ExposedMedia,Media,PlateCopyParams", ",i?,o_ i_,i_,i_");
        this.mapPut(JDFNode.EnumType.FormatConversion.getName(), ",FormatConversionParams,RunList", ",i_,o_ i_");
        this.mapPut(JDFNode.EnumType.ImageReplacement.getName(), ",ImageCompressionParams,ImageReplacementParams,RunList", ",i?,i_,o_ i_");
        this.mapPut(JDFNode.EnumType.ImageEnhancement.getName(), ",ImageEnhancementParams,RunList", ",i_,o_ i_");
        this.mapPut(JDFNode.EnumType.ImageSetting.getName(), ",ColorantControl,DevelopingParams,ImageSetterParams,Media,RunList,TransferCurvePool,ExposedMedia", ",i?,i?,i?,i?,i_,i?,o_ i?");
        this.mapPut(JDFNode.EnumType.Imposition.getName(), ",Layout,RunList", ",i_,o_ i?Marks i_Document");
        this.mapPut(JDFNode.EnumType.InkZoneCalculation.getName(), ",InkZoneCalculationParams,InkZoneProfile,Layout,TransferCurvePool,Sheet,Preview", ",i?,o_,i?,i?,i?,i_");
        this.mapPut(JDFNode.EnumType.Interpreting.getName(), ",ColorantControl,FontPolicy,InterpretedPDLData,InterpretingParams,PDLResourceAlias,RunList", ",i?,i?,o?,i_,i*,o? i_");
        this.mapPut(JDFNode.EnumType.LayoutElementProduction.getName(), ",LayoutElement,RunList,LayoutElementProductionParams", ",o? i*,i* o?,i?");
        this.mapPut(JDFNode.EnumType.LayoutPreparation.getName(), ",LayoutPreparationParams,RunList,Layout,TransferCurvePool", ",i_,o?Marks i?Marks i?Document,o_,o?");
        this.mapPut(JDFNode.EnumType.PageAssigning.getName(), ",PageAssignParams,RunList", ",i_,o_ i+");
        this.mapPut(JDFNode.EnumType.PDFToPSConversion.getName(), ",PDFToPSConversionParams,RunList", ",i_,o_ i_");
        this.mapPut(JDFNode.EnumType.PDLCreation.getName(), ",ImageCompressionParams,PDLCreationParams,RunList", ",i?,i?,o_ i_");
        this.mapPut(JDFNode.EnumType.Preflight.getName(), ",PreflightParams,PreflightReportRulePool,RunList,PreflightReport", ",i_,i_,i_,o_");
        this.mapPut(JDFNode.EnumType.PreviewGeneration.getName(), ",ColorantControl,ExposedMedia,PreviewGenerationParams,RunList,TransferCurvePool,Preview", ",i?,i?,i_,i?,i?,o_ i?");
        this.mapPut(JDFNode.EnumType.Proofing.getName(), ",ColorantControl,ColorSpaceConversionParams,ExposedMedia,Layout,Media,ProofingParams,RunList", ",i?,i?,o_,i?,i_,i_,i?Marks i_Document");
        this.mapPut(JDFNode.EnumType.PSToPDFConversion.getName(), ",FontParams,ImageCompressionParams,PSToPDFConversionParams,RunList", ",i?,i?,i?,o_ i_");
        this.mapPut(JDFNode.EnumType.RasterReading.getName(), ",RasterReadingParams,RunList", ",i?,o_ i_");
        this.mapPut(JDFNode.EnumType.Rendering.getName(), ",InterpretedPDLData,Media,RenderingParams,RunList", ",i?,i?,i?,o_ i?");
        this.mapPut(JDFNode.EnumType.Scanning.getName(), ",ExposedMedia,ScanParams,RunList", ",i_,i_,o_");
        this.mapPut(JDFNode.EnumType.Screening.getName(), ",RunList,ScreeningParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Separation.getName(), ",ColorantControl,RunList,SeparationControlParams", ",i?,o_ i_,i_");
        this.mapPut(JDFNode.EnumType.SheetOptimizing.getName(), ",SheetOptimizingParams,Assembly,StrippingParams", ",i?,i*,o_");
        this.mapPut(JDFNode.EnumType.SoftProofing.getName(), ",ColorantControl,ColorSpaceConversionParams,Layout,ProofingParams,RunList", ",i?,i?,i?,i_,i?Marks i_Document");
        this.mapPut(JDFNode.EnumType.Stripping.getName(), ",RunList,Layout,Assembly,TransferCurvePool,StrippingParams,ColorantControl", ",o?Marks o?Document i?Document,o_,i+,i?,i_,i?");
        this.mapPut(JDFNode.EnumType.Tiling.getName(), ",RunList,Tile", ",o_ i?Marks i_Surface,i_");
        this.mapPut(JDFNode.EnumType.Trapping.getName(), ",ColorantControl,RunList,TrappingDetails,FontPolicy", ",i?,o_ i_,i_,i?");
        this.mapPut(JDFNode.EnumType.ConventionalPrinting.getName(), ",ColorantControl,Component,ConventionalPrintingParams,ExposedMedia,Ink,InkZoneProfile,Layout,Media,PrintCondition,Sheet,TransferCurvePool", ",i?,o?Waste o_ i?Proof i?Input i?,i_,i?Plate i?Cylinder i?Proof,i?,i?,i?,i?,i?,i?,i? i?MountingTape");
        this.mapPut(JDFNode.EnumType.DigitalPrinting.getName(), ",ColorantControl,Component,DigitalPrintingParams,ExposedMedia,Ink,PrintCondition,Media,RunList,Layout,Sheet,TransferCurvePool", ",i?,o?Waste o_ i?Proof i*Input i*,i_,i?,i?,i?,i*,i_,i?,i?,i?");
        this.mapPut(JDFNode.EnumType.IDPrinting.getName(), ",ColorantControl,Component,ExposedMedia,FontPolicy,Ink,InterpretingParams,IDPrintingParams,Media,RenderingParams,RunList,ScreeningParams,TransferFunctionControl", ",i?,o?Waste o_Good i?Proof i?Input i?Cover,i?,i?,i?,i*,i?,i?,i?,i_,i?,i?");
        this.mapPut(JDFNode.EnumType.Varnishing.getName(), ",Component,ExposedMedia,Ink,Media,VarnishingParams", ",i? o_,o*,i?,i?,i?");
        this.mapPut(JDFNode.EnumType.AdhesiveBinding.getName(), ",AdhesiveBindingParams,Component", ",i_,o_ i?Cover i_BookBlock");
        this.mapPut(JDFNode.EnumType.BlockPreparation.getName(), ",Component,BlockPreparationParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.BoxFolding.getName(), ",Component,BoxFoldingParams", ",o_ i*Application i_,i_");
        this.mapPut(JDFNode.EnumType.BoxPacking.getName(), ",Component,BoxPackingParams", ",o_ i?Box i_,i_");
        this.mapPut(JDFNode.EnumType.Bundling.getName(), ",Component,BundlingParams,Media", ",o_ i_,i_,i?");
        this.mapPut(JDFNode.EnumType.CaseMaking.getName(), ",Component,CaseMakingParams,Media", ",o_ i?CoverMaterial,i_,i?SpineBoard i_CoverBoard i?CoverMaterial");
        this.mapPut(JDFNode.EnumType.CasingIn.getName(), ",Component,CasingInParams", ",o_ i_Case i_,i_");
        this.mapPut(JDFNode.EnumType.ChannelBinding.getName(), ",ChannelBindingParams,Component", ",i_,o_ i?Cover i_BookBlock");
        this.mapPut(JDFNode.EnumType.CoilBinding.getName(), ",CoilBindingParams,Component", ",i_,o_ i_");
        this.mapPut(JDFNode.EnumType.Collecting.getName(), ",CollectingParams,Component,DBRules,DBSelection,IdentificationField,Assembly", ",i?,o_ i+,i*,i?,i?,i?");
        this.mapPut(JDFNode.EnumType.CoverApplication.getName(), ",Component,CoverApplicationParams", ",o_ i_Cover i_,i_");
        this.mapPut(JDFNode.EnumType.Creasing.getName(), ",CreasingParams,Component", ",i_,o_ i_");
        this.mapPut(JDFNode.EnumType.Cutting.getName(), ",Component,CutBlock,CutMark,CuttingParams,Media", ",o* i?,i*,i*,i_,o* i?");
        this.mapPut(JDFNode.EnumType.Dividing.getName(), ",Component,DividingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Embossing.getName(), ",Component,EmbossingParams,Media,Tool", ",o_ i_,i_,i?,i?");
        this.mapPut(JDFNode.EnumType.EndSheetGluing.getName(), ",Component,EndSheetGluingParams", ",o_ i_FrontEndSheet i_BookBlock i_BackEndSheet,i_");
        this.mapPut(JDFNode.EnumType.Feeding.getName(), ",Component,FeedingParams,Media", ",o* i*,i_,o* i*");
        this.mapPut(JDFNode.EnumType.Folding.getName(), ",Component,FoldingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Gathering.getName(), ",Assembly,Component,DBRules,DBSelection,GatheringParams,IdentificationField", ",i?,o_ i+,i*,i?,i_,i?");
        this.mapPut(JDFNode.EnumType.Gluing.getName(), ",Component,GluingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.HeadBandApplication.getName(), ",Component,HeadBandApplicationParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.HoleMaking.getName(), ",Component,HoleMakingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Inserting.getName(), ",Component,DBRules,DBSelection,IdentificationField,InsertingParams", ",o_ i_Child i?Mother i?,i?,i?,i?,i_");
        this.mapPut(JDFNode.EnumType.Jacketing.getName(), ",Component,JacketingParams", ",o_ i_Jacket i_Book,i_");
        this.mapPut(JDFNode.EnumType.Labeling.getName(), ",Component,LabelingParams", ",o_ i?Label i_,i_");
        this.mapPut(JDFNode.EnumType.Laminating.getName(), ",Component,LaminatingParams,Media", ",o_ i_,i_,i?");
        this.mapPut(JDFNode.EnumType.LongitudinalRibbonOperations.getName(), ",Component,LongitudinalRibbonOperationParams", ",o+ i_,i_");
        this.mapPut(JDFNode.EnumType.Numbering.getName(), ",Component,NumberingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Palletizing.getName(), ",Component,PalletizingParams,Pallet", ",o_ i_,i_,i_");
        this.mapPut(JDFNode.EnumType.Perforating.getName(), ",PerforatingParams,Component", ",i_,o_ i_");
        this.mapPut(JDFNode.EnumType.PlasticCombBinding.getName(), ",Component,PlasticCombBindingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.PrintRolling.getName(), ",Component,PrintRollingParams,RollStand", ",o_ i_,i?,i?");
        this.mapPut(JDFNode.EnumType.RingBinding.getName(), ",Component,RingBindingParams", ",o_ i?RingBinder i_BookBlock,i_");
        this.mapPut(JDFNode.EnumType.SaddleStitching.getName(), ",Component,SaddleStitchingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.ShapeCutting.getName(), ",Component,ShapeCuttingParams,Tool", ",o+ i_,i?,i*");
        this.mapPut(JDFNode.EnumType.ShapeDefProduction.getName(), ",LayoutElement,ShapeDefProductionParams,ShapeDef", ",i?,i_,o+");
        this.mapPut(JDFNode.EnumType.Shrinking.getName(), ",Component,ShrinkingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.SideSewing.getName(), ",Component,SideSewingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.SpinePreparation.getName(), ",Component,SpinePreparationParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.SpineTaping.getName(), ",Component,SpineTapingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Stacking.getName(), ",Component,StackingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.StaticBlocking.getName(), ",Component,StaticBlockingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Stitching.getName(), ",Component,StitchingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Strapping.getName(), ",Component,StrappingParams,Strap", ",o_ i_,i_,i?");
        this.mapPut(JDFNode.EnumType.StripBinding.getName(), ",Component,StripBindingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.ThreadSealing.getName(), ",Component,ThreadSealingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.ThreadSewing.getName(), ",Component,ThreadSewingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Trimming.getName(), ",Component,TrimmingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.WebInlineFinishing.getName(), ",Assembly,Component,ProductionPath,StrippingParams,WebInlineFinishingParams", ",i?,o_ i_,i?,i?,i?");
        this.mapPut(JDFNode.EnumType.Winding.getName(), ",Component,Media,WindingParams", ",i_ o_,i? i?Core,i?");
        this.mapPut(JDFNode.EnumType.WireCombBinding.getName(), ",Component,WireCombBindingParams", ",o_ i_,i_");
        this.mapPut(JDFNode.EnumType.Wrapping.getName(), ",Component,WrappingParams,Media", ",o_ i_,i_,i?");
        this.mapPut(JDFNode.EnumType.PrepressPreparation.getName(), ",RunList,*", ",i_Document o_Document,i* o*");
        this.mapPut(JDFNode.EnumType.ImpositionPreparation.getName(), ",Layout,RunList,*", ",o_,i?Document o?Document o_Marks,,i* o*");
        this.mapPut(JDFNode.EnumType.RIPing.getName(), ",InterpretingParams,RenderingParams,RunList,*", ",i?,i?,o_ i_Document i?Marks,i* o*");
        this.mapPut(JDFNode.EnumType.PlateSetting.getName(), ",*,ExposedMedia,Preview", ",i* o*,o_,o*");
        this.mapPut(JDFNode.EnumType.PlateMaking.getName(), ",*,RunList,ExposedMedia,Preview,Media", ",i* o*,i_Document i?Marks,o_,o*,i_");
        this.mapPut(JDFNode.EnumType.ProofAndPlateMaking.getName(), ",*,RunList,ExposedMedia,Preview,Media", ",i* o*,i_Document i?Marks,o+,o*,i_");
        this.mapPut(JDFNode.EnumType.ImpositionProofing.getName(), ",*,RunList,ExposedMedia,Media", ",i* o*,i_Document i?Marks,o+,i_");
        this.mapPut(JDFNode.EnumType.PageProofing.getName(), ",*,RunList,ExposedMedia,Media", ",i* o*,i_Document i?Marks,o+,i_");
        this.mapPut(JDFNode.EnumType.PageSoftProofing.getName(), ",*,RunList", ",i* o*,i_Document i?Marks");
        this.mapPut(JDFNode.EnumType.ProofImaging.getName(), ",InterpretingParams,RenderingParams,RunList,*", ",i?,i?,i? i?Document i?Marks,i* o*");
    }

    Vector<String> typeLinkNames(JDFNode.EnumType typ) {
        if (typ == null) {
            return null;
        }
        LinkInfoMap map = this.m_LinkInfoMap.get(typ.getName());
        return ContainerUtil.getKeyVector(map);
    }

    HashSet<String> getGenericLinkNames() {
        if (this.nameSet == null) {
            this.nameSet = new HashSet();
            this.nameSet.addAll(new VString(this.m_GenericLinkNames));
        }
        return this.nameSet;
    }

    LinkInfoMap getTypeMap(JDFNode.EnumType typeNum, boolean addStar) {
        LinkInfoMap info;
        LinkInfoMap linkInfoMap = info = typeNum == null ? null : this.m_LinkInfoMap.get(typeNum.getName());
        if (info == null && addStar) {
            info = this.m_LinkInfoMap.get("*");
        }
        return new LinkInfoMap(info);
    }

    public LinkInfoMap getLinkInfoMap(JDFNode.EnumType typ, VString vTypes) {
        if (typ == null) {
            return this.getTypeMap(JDFNode.EnumType.ProcessGroup, false);
        }
        if (typ.equals((Object)JDFNode.EnumType.Combined) || typ == JDFNode.EnumType.ProcessGroup && vTypes != null) {
            if (vTypes == null) {
                return null;
            }
            LinkInfoMap ret = new LinkInfoMap(this.m_LinkInfoMap.get("*"));
            for (String s : vTypes) {
                JDFNode.EnumType t = JDFNode.EnumType.getEnum(s);
                if (t == null) {
                    t = JDFNode.EnumType.ProcessGroup;
                }
                LinkInfoMap typeLinkInfo = this.getTypeMap(t, false);
                ret.merge(typeLinkInfo);
            }
            return ret;
        }
        return this.getTypeMap(typ, true);
    }

    public VString getLinkNames(JDFNode.EnumType typ, VString vTypes) {
        LinkInfoMap map = this.getLinkInfoMap(typ, vTypes);
        return new VString(ContainerUtil.getKeyVector(map));
    }

    public String toString() {
        return "LinkValidatorMap [m_LinkInfoMap=" + this.m_LinkInfoMap + "]";
    }
}

