/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoComChannel;
import org.cip4.jdflib.util.StringUtil;

public class JDFComChannel
extends JDFAutoComChannel {
    private static final long serialVersionUID = 1L;
    public static final String MAILTO = "mailto:";
    public static final String TEL = "tel:";

    public JDFComChannel(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFComChannel(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFComChannel(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFComChannel[  --> " + super.toString() + " ]";
    }

    public void setEMailLocator(String eMail) {
        String eMailLocal = eMail;
        if (eMailLocal != null) {
            eMailLocal = eMailLocal.trim();
        }
        if (eMailLocal == null || !StringUtil.matchesIgnoreCase(eMailLocal, "(mailto:)?([_.a-zA-Z0-9\\-])+[@]([_.a-zA-Z0-9\\-])+[.]([_.a-zA-Z0-9\\-])+")) {
            throw new IllegalArgumentException("illegal email address:" + eMailLocal);
        }
        this.setChannelType(JDFAutoComChannel.EnumChannelType.Email);
        if (!eMailLocal.toLowerCase().startsWith(MAILTO)) {
            eMailLocal = MAILTO + eMailLocal;
        }
        this.setLocator(eMailLocal);
    }

    public String getEMailAddress() {
        if (!JDFAutoComChannel.EnumChannelType.Email.equals((Object)this.getChannelType())) {
            return null;
        }
        String locator = this.getLocator();
        if (!StringUtil.matchesIgnoreCase(locator, "(mailto:)?([_.a-zA-Z0-9\\-])+[@]([_.a-zA-Z0-9\\-])+[.]([_.a-zA-Z0-9\\-])+")) {
            return null;
        }
        return StringUtil.stripPrefix(locator, MAILTO, true);
    }

    public String getPhoneNumber(boolean stripNonNumerical) {
        JDFAutoComChannel.EnumChannelType channelType = this.getChannelType();
        if (!(JDFAutoComChannel.EnumChannelType.Fax.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Mobile.equals((Object)channelType))) {
            return null;
        }
        String locator = this.getLocator();
        if (!StringUtil.matchesIgnoreCase(locator, "(tel:)?([+])?(([0-9./\\-])|[(]([0-9./\\-])[)])+")) {
            return null;
        }
        locator = StringUtil.stripPrefix(locator, TEL, true);
        if (stripNonNumerical) {
            locator = StringUtil.stripNot(locator, "+0123456789");
        }
        return locator;
    }

    public void setPhoneNumber(String phone) {
        if (phone == null) {
            this.setLocator(null);
            return;
        }
        JDFAutoComChannel.EnumChannelType channelType = this.getChannelType();
        this.setPhoneNumber(phone, ".", channelType);
    }

    public void setPhoneNumber(String phone, String replaceForBlank, JDFAutoComChannel.EnumChannelType channelType) {
        if (channelType == null) {
            channelType = this.getChannelType();
        }
        if (!(JDFAutoComChannel.EnumChannelType.Fax.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType) || JDFAutoComChannel.EnumChannelType.Mobile.equals((Object)channelType))) {
            throw new IllegalArgumentException("illegal channelType: " + (Object)((Object)channelType));
        }
        if (phone != null) {
            phone = phone.trim();
        }
        if ((phone = StringUtil.replaceCharSet(phone, " ", replaceForBlank, 0)) == null || !StringUtil.matches(phone, "(tel:)?([+])?(([0-9./\\-])|[(]([0-9./\\-])[)])+")) {
            throw new IllegalArgumentException("illegal phone number:" + phone);
        }
        this.setChannelType(channelType);
        if (!phone.toLowerCase().startsWith(TEL)) {
            phone = TEL + phone;
        }
        this.setLocator(phone);
    }

    @Override
    public JDFAutoComChannel.EnumChannelType getChannelType() {
        JDFAutoComChannel.EnumChannelType channelType = super.getChannelType();
        if (JDFAutoComChannel.EnumChannelType.Phone.equals((Object)channelType)) {
            String ctd = this.getChannelTypeDetails();
            if ("mobile".equals(ctd = StringUtil.normalize(ctd, true))) {
                channelType = JDFAutoComChannel.EnumChannelType.Mobile;
            }
        }
        return channelType;
    }

    public static class EnumChannelTypeDetails
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumChannelTypeDetails Unknown = new EnumChannelTypeDetails("Unknown");
        public static final EnumChannelTypeDetails LandLine = new EnumChannelTypeDetails("LandLine");
        public static final EnumChannelTypeDetails Mobile = new EnumChannelTypeDetails("Mobile");
        public static final EnumChannelTypeDetails Secure = new EnumChannelTypeDetails("Secure");
        public static final EnumChannelTypeDetails ISDN = new EnumChannelTypeDetails("ISDN");
        public static final EnumChannelTypeDetails Form = new EnumChannelTypeDetails("Form");
        public static final EnumChannelTypeDetails Target = new EnumChannelTypeDetails("Target");

        private EnumChannelTypeDetails(String name) {
            super(name, m_startValue++);
        }

        public static EnumChannelTypeDetails getEnum(String enumName) {
            return (EnumChannelTypeDetails)EnumChannelTypeDetails.getEnum(EnumChannelTypeDetails.class, (String)enumName);
        }

        public static EnumChannelTypeDetails getEnum(int enumValue) {
            return (EnumChannelTypeDetails)EnumChannelTypeDetails.getEnum(EnumChannelTypeDetails.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumChannelTypeDetails.getEnumMap(EnumChannelTypeDetails.class);
        }

        public static List getEnumList() {
            return EnumChannelTypeDetails.getEnumList(EnumChannelTypeDetails.class);
        }

        public static Iterator iterator() {
            return EnumChannelTypeDetails.iterator(EnumChannelTypeDetails.class);
        }
    }
}

