/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoContentObject;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFMatrix;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.ifaces.IPlacedObject;
import org.cip4.jdflib.util.StringUtil;

public class JDFContentObject
extends JDFAutoContentObject
implements IPlacedObject {
    private static final long serialVersionUID = 1L;

    public JDFContentObject(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFContentObject(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFContentObject(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFContentObject[  --> " + super.toString() + " ]";
    }

    @Override
    public void setTrimSize(double x, double y, int precision) {
        this.setTrimSize(new JDFXYPair(x, y), precision);
    }

    @Override
    public void setTrimSize(JDFXYPair jdfxyPair, int precision) {
        this.setAttribute("TrimSize", jdfxyPair, null, precision);
    }

    @Override
    public void setCTM(JDFMatrix value, int precision) {
        this.setAttribute("CTM", value, null, precision);
    }

    @Override
    public void setTrimCTM(JDFMatrix value, int precision) {
        this.setAttribute("TrimCTM", value, null, precision);
    }

    @Override
    public void setTrimSize(double x, double y) {
        this.setTrimSize(new JDFXYPair(x, y));
    }

    @Override
    public void setClipPath(String value, int precision) {
        VString v = StringUtil.tokenize(value, " ", false);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                String s = v.get(i);
                if (!StringUtil.isNumber(s)) continue;
                v.set(i, StringUtil.formatDouble(StringUtil.parseDouble(s, 0.0), precision));
            }
        }
        super.setClipPath(StringUtil.setvString(v));
    }

    public static int calcOrd(int ord, int nPages, int loop, int maxOrdFront, int maxOrdBack, int frontOffset) {
        int page;
        int maxOrd = maxOrdFront + maxOrdBack;
        if (maxOrd * loop >= nPages) {
            return -1;
        }
        if (ord >= 0) {
            page = ord + loop * maxOrdFront;
        } else {
            int end = nPages + maxOrd - 1 - (nPages + maxOrd - 1) % maxOrd;
            page = end - loop * maxOrdBack + ord;
        }
        return page < nPages ? page + frontOffset : -1;
    }
}

