/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.io.File;
import java.io.InputStream;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoFileSpec;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.MimeReader;
import org.w3c.dom.DOMException;

public class JDFFileSpec
extends JDFAutoFileSpec
implements IURLSetter {
    private static final long serialVersionUID = 1L;

    public JDFFileSpec(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFFileSpec(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFFileSpec(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFFileSpec[  --> " + super.toString() + " ]";
    }

    public void setAbsoluteFileURL(File f, boolean bEscape128) {
        String s = UrlUtil.fileToUrl(f, bEscape128);
        this.setMimeURL(s);
    }

    public void setRelativeURL(File f, File baseDir, boolean bEscape128) {
        String s = UrlUtil.getRelativeURL(f, baseDir, bEscape128);
        this.setMimeURL(s);
    }

    public InputStream getURLInputStream() {
        return this.getURLInputStream(this.getURL());
    }

    public void setMimeURL(String url) {
        this.setURL(url);
        this.setMimeType(UrlUtil.getMimeTypeFromURL(url));
    }

    @Deprecated
    public File moveToDir(File dir) {
        return UrlUtil.moveToDir(this, dir, true);
    }

    public String getFileName() {
        String url = this.getURL();
        if (StringUtil.getNonEmpty(url) == null) {
            return null;
        }
        return new MimeReader(this.getOwnerDocument_KElement().getMultiPart()).getFileName(url);
    }

    @Deprecated
    public static String getMimeTypeFromURL(String url) {
        return UrlUtil.getMimeTypeFromURL(url);
    }
}

