/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.commons.io.IOUtils;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;

public class ByteArrayIOFileStream
extends ByteArrayIOStream {
    private final long maxLength;
    private File file;
    private RandomAccessFile os;
    private boolean isTmpFile;

    public static ByteArrayIOStream.ByteArrayIOInputStream getBufferedInputStream(InputStream is, long maxLen) {
        if (is == null) {
            return null;
        }
        if (is instanceof ByteArrayIOStream.ByteArrayIOInputStream) {
            return ((ByteArrayIOStream.ByteArrayIOInputStream)is).getNewStream();
        }
        ByteArrayIOFileStream byteArrayIOStream = new ByteArrayIOFileStream(is, maxLen);
        ByteArrayIOStream.ByteArrayIOInputStream inputStream = ((ByteArrayIOStream)byteArrayIOStream).getInputStream();
        return inputStream;
    }

    public ByteArrayIOFileStream(long maxLength) {
        this.maxLength = maxLength;
        this.file = null;
        this.isTmpFile = false;
        this.os = null;
    }

    public ByteArrayIOFileStream(InputStream is, long maxLength) {
        this(maxLength);
        this.setStream(is);
    }

    public ByteArrayIOFileStream(File f, long maxLength, boolean readOnly) {
        this(maxLength);
        if (f == null) {
            return;
        }
        this.file = f;
        if (f.length() > maxLength) {
            try {
                this.os = new RandomAccessFile(f, readOnly ? "r" : "rw");
            }
            catch (FileNotFoundException e) {
                this.log.error((Object)("cannot open file " + f), (Throwable)e);
            }
        } else {
            BufferedInputStream fis = FileUtil.getBufferedInputStream(f);
            this.setStream(fis);
        }
    }

    @Override
    public ByteArrayIOStream.ByteArrayIOInputStream getInputStream() {
        if (this.os != null) {
            ByteArrayIOFileInputStream byteArrayIOFileInputStream = new ByteArrayIOFileInputStream(this);
            byteArrayIOFileInputStream.seek(0L);
            return byteArrayIOFileInputStream;
        }
        return super.getInputStream();
    }

    @Override
    public synchronized String toString() {
        return "ByteArrayIOFileStream: size= " + this.count + " maxLength=" + this.maxLength;
    }

    @Override
    public synchronized void write(int b) {
        this.ensureStream(this.count + 1);
        if (this.os != null) {
            try {
                this.os.write(b);
            }
            catch (IOException iOException) {}
        } else {
            super.write(b);
        }
    }

    private void ensureStream(long newSize) {
        if (newSize > this.maxLength && this.os == null) {
            if (this.file == null) {
                try {
                    this.isTmpFile = true;
                    this.file = File.createTempFile("ByteArray", null);
                }
                catch (IOException e) {
                    this.log.error((Object)"Cannot create temp file ", (Throwable)e);
                }
            }
            try {
                this.os = new RandomAccessFile(this.file, "rw");
                this.os.write(this.buf, this.pos, this.count);
                this.buf = null;
                this.count = 0;
            }
            catch (Exception e) {
                this.log.error((Object)("cannot create file " + this.file));
            }
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.ensureStream(this.count + len);
        if (this.os != null) {
            try {
                this.os.write(b, off, len);
            }
            catch (IOException e) {}
        } else {
            super.write(b, off, len);
        }
    }

    @Override
    public void close() {
        try {
            if (this.os != null) {
                this.os.close();
                this.os = null;
            }
            if (this.isTmpFile && this.file != null) {
                this.file.delete();
                this.file = null;
                this.isTmpFile = false;
            }
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    void setStream(InputStream is) {
        if (is instanceof ByteArrayIOFileInputStream) {
            ByteArrayIOFileInputStream bais = (ByteArrayIOFileInputStream)is;
            this.file = ((ByteArrayIOFileInputStream)bais).ios.file;
            this.isTmpFile = false;
            this.os = ((ByteArrayIOFileInputStream)bais).ios.os;
        } else if (is != null) {
            int avail = 0;
            try {
                avail = is.available();
                if ((long)avail > this.maxLength) {
                    this.ensureStream(avail);
                    IOUtils.copy((InputStream)is, (OutputStream)this);
                } else {
                    super.setStream(is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized int size() {
        if (this.os != null) {
            try {
                return (int)this.os.length();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.size();
    }

    public static class ByteArrayIOFileInputStream
    extends ByteArrayIOStream.ByteArrayIOInputStream {
        private final ByteArrayIOFileStream ios;
        private long pos;
        private long mark;

        ByteArrayIOFileInputStream(ByteArrayIOFileStream ios) {
            super(new byte[1], 0);
            this.ios = ios;
            this.mark = 0L;
            try {
                this.pos = ios.os.getFilePointer();
            }
            catch (IOException e) {
                this.pos = 0L;
            }
        }

        @Override
        public ByteArrayIOStream.ByteArrayIOInputStream getNewStream() {
            ByteArrayIOFileInputStream byteArrayIOFileInputStream = new ByteArrayIOFileInputStream(this.ios);
            byteArrayIOFileInputStream.pos = this.pos;
            return byteArrayIOFileInputStream;
        }

        @Override
        public synchronized String toString() {
            return "ByteArrayIOFileInputStream: " + this.ios;
        }

        @Override
        public long getCount() {
            try {
                return this.ios.os.length();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        @Override
        public void seek(long pos) {
            if (pos < 0L) {
                pos += this.getCount();
            }
            try {
                if (this.ios.os.getFilePointer() != pos) {
                    this.ios.os.seek(pos);
                    this.pos = pos;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public long tell() {
            return this.pos;
        }

        @Override
        public byte[] getBuf() {
            return null;
        }

        @Override
        public synchronized int read() {
            try {
                this.ios.os.seek(this.pos);
                int read = this.ios.os.read();
                if (read >= 0) {
                    ++this.pos;
                }
                return read;
            }
            catch (IOException e) {
                return -1;
            }
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            try {
                this.seek(this.pos);
                int read = this.ios.os.read(b, off, len);
                if (read > 0) {
                    this.pos += (long)read;
                }
                return read;
            }
            catch (IOException e) {
                return 0;
            }
        }

        @Override
        public synchronized long skip(long n) {
            try {
                this.pos += n;
                this.ios.os.seek(this.pos);
                return this.pos;
            }
            catch (IOException e) {
                return 0L;
            }
        }

        @Override
        public synchronized int available() {
            return (int)(this.getCount() - this.pos);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public synchronized void reset() {
            this.seek(this.mark);
        }

        @Override
        public void close() throws IOException {
        }

        public void closeAll() {
            this.ios.close();
        }
    }
}

