/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.cip4.jdflib.ifaces.IMatches;
import org.cip4.jdflib.util.VectorMap;

public class ContainerUtil {
    public static <a> Set<a> toHashSet(Enumeration<a> enumeration) {
        if (enumeration == null) {
            return null;
        }
        HashSet<a> s = new HashSet<a>();
        while (enumeration.hasMoreElements()) {
            s.add(enumeration.nextElement());
        }
        return s;
    }

    public static <a> Set<a> toHashSet(List<a> list) {
        if (list == null) {
            return null;
        }
        int size = list.size();
        HashSet<a> s = new HashSet<a>(size + 10);
        for (int i = 0; i < size; ++i) {
            s.add(list.get(i));
        }
        return s;
    }

    public static <a> Set<a> toHashSet(a[] l) {
        if (l == null) {
            return null;
        }
        HashSet<a> s = new HashSet<a>(l.length + 10);
        for (int i = 0; i < l.length; ++i) {
            s.add(l[i]);
        }
        return s;
    }

    public static <a> Vector<a> toVector(a[] array) {
        if (array == null) {
            return null;
        }
        Vector<a> v = new Vector<a>();
        v.ensureCapacity(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            v.add(array[i]);
        }
        return v;
    }

    public static <a> Collection<a> addAll(Collection<a> c1, Collection<a> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        c1.addAll(c2);
        return c1;
    }

    public static <a> IMatches getMatch(Collection<? extends IMatches> c, a obj, int iSkip) {
        if (c == null) {
            return null;
        }
        if (iSkip < 0) {
            Vector<IMatches> v = ContainerUtil.getMatches(c, obj);
            if (v == null) {
                return null;
            }
            iSkip = v.size() + iSkip;
            if (iSkip < 0) {
                return null;
            }
            return v.get(iSkip);
        }
        for (IMatches iMatches : c) {
            if (!iMatches.matches(obj) || iSkip-- > 0) continue;
            return iMatches;
        }
        return null;
    }

    public static <a> Vector<IMatches> getMatches(Collection<? extends IMatches> c, a obj) {
        if (c == null) {
            return null;
        }
        Vector<IMatches> v = new Vector<IMatches>();
        for (IMatches iMatches : c) {
            if (!iMatches.matches(obj)) continue;
            v.add(iMatches);
        }
        return v.size() == 0 ? null : v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <a extends Comparable<? super a>, b> Vector<b> toValueVector(Map<a, b> m, boolean sortByKey) {
        if (!sortByKey) {
            return ContainerUtil.toValueVector(m);
        }
        if (m == null) {
            return null;
        }
        Map<a, b> map = m;
        synchronized (map) {
            Set<Map.Entry<a, b>> entrySet = m.entrySet();
            if (entrySet.size() == 0) {
                return null;
            }
            Vector<b> v = new Vector<b>();
            v.ensureCapacity(entrySet.size());
            Iterator<Map.Entry<a, b>> it = entrySet.iterator();
            Vector<Comparable> keys = new Vector<Comparable>();
            keys.ensureCapacity(entrySet.size());
            while (it.hasNext()) {
                Comparable key = (Comparable)it.next().getKey();
                if (key == null) continue;
                keys.add(key);
            }
            Collections.sort(keys);
            for (int i = 0; i < keys.size(); ++i) {
                v.add(m.get(keys.get(i)));
            }
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <a, b> Vector<b> toValueVector(Map<a, b> m) {
        if (m == null) {
            return null;
        }
        Map<a, b> map = m;
        synchronized (map) {
            Vector<b> v = new Vector<b>();
            Collection<b> values = m.values();
            if (values.size() == 0) {
                return null;
            }
            v.addAll(values);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <a, b> VectorMap<b, a> getInvertedMap(Map<a, b> m) {
        if (m == null) {
            return null;
        }
        Map<a, b> map = m;
        synchronized (map) {
            VectorMap inv = new VectorMap();
            Set<a> keys = m.keySet();
            if (keys.size() == 0) {
                return null;
            }
            for (Object key : keys) {
                b val = m.get(key);
                if (val == null) continue;
                inv.putOne(val, key);
            }
            return inv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <a> Vector<a> getKeyVector(Map<a, ?> m) {
        if (m == null) {
            return null;
        }
        Map<a, ?> map = m;
        synchronized (map) {
            Set<a> keySet = m.keySet();
            if (keySet.size() == 0) {
                return null;
            }
            Vector<a> v = new Vector<a>();
            v.ensureCapacity(keySet.size());
            v.addAll(keySet);
            return v;
        }
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static boolean matches(IMatches a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.matches(b);
    }

    public static boolean matchesExisting(IMatches a, Object b) {
        if (a == null || b == null) {
            return true;
        }
        return a.matches(b);
    }

    public static int compare(Comparable c0, Comparable c1) {
        if (c0 == null) {
            return c1 == null ? 0 : -1;
        }
        if (c1 == null) {
            return 1;
        }
        return c0.compareTo(c1);
    }

    public static <a> void ensureSize(int size, Collection<a> coll) {
        int s2 = coll.size();
        if (s2 < size) {
            for (int i = s2; i < size; ++i) {
                coll.add(null);
            }
        }
    }

    public static <a> Collection<a> unify(Collection<a> c) {
        if (c == null || c.size() < 2) {
            return c;
        }
        LinkedHashSet<a> lhsIn = new LinkedHashSet<a>(c.size());
        for (a el : c) {
            if (lhsIn.contains(el)) continue;
            lhsIn.add(el);
        }
        if (lhsIn.size() < c.size()) {
            c.clear();
            c.addAll(lhsIn);
        }
        return c;
    }
}

