/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.util.NumberFormatter;
import org.cip4.jdflib.util.StringUtil;

public class UnitParser {
    private int precision;

    public UnitParser() {
        this.setPrecision(4);
    }

    public String extractUnits(String val) {
        if (val == null) {
            return val;
        }
        VString v = StringUtil.tokenize(val, " ", false);
        VString keep = new VString(v);
        boolean oneGood = false;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            String tmp = v.get(i).toLowerCase();
            double factor = 1.0;
            if (tmp.endsWith("mm")) {
                factor = 2.834645669291339;
                tmp = StringUtil.leftStr(tmp, -2);
            } else if (tmp.endsWith("cm")) {
                factor = 28.346456692913385;
                tmp = StringUtil.leftStr(tmp, -2);
            } else if (tmp.endsWith("in")) {
                factor = 72.0;
                tmp = StringUtil.leftStr(tmp, -2);
            }
            if (factor > 0.0 && i > 0 && tmp == null && StringUtil.isNumber(keep.get(i - 1))) {
                if (i < 2 || !"\"".equals(v.get(i - 2))) {
                    tmp = v.get(i - 1);
                    v.setElementAt("\"", i - 1);
                } else {
                    oneGood = false;
                    break;
                }
            }
            if (!StringUtil.isNumber(tmp)) {
                factor = 0.0;
            }
            if (factor != 0.0) {
                if (factor == 1.0 && (tmp.startsWith("0") || tmp.startsWith("-0")) && StringUtil.isInteger(tmp)) {
                    v.setElementAt(tmp, i);
                    continue;
                }
                oneGood = true;
                double dbl = StringUtil.parseDouble(tmp, -1.0) * factor;
                v.setElementAt(new NumberFormatter().formatDouble(dbl, this.precision), i);
                continue;
            }
            oneGood = false;
            break;
        }
        if (oneGood) {
            val = StringUtil.setvString(v, " ", null, null);
            val = StringUtil.replaceString(val, "\" ", "");
        }
        return val;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String toString() {
        return "UnitParser [precision=" + this.precision + "]";
    }
}

