/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.xml;

import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.ifaces.IStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XSLTransformHelper
implements IStreamWriter {
    private final KElement elem;
    private final XMLDoc xsl;
    private final Log log;

    public XSLTransformHelper(KElement e, XMLDoc xsl) {
        this.elem = e;
        this.xsl = xsl;
        this.log = LogFactory.getLog(this.getClass());
    }

    public XSLTransformHelper(XMLDoc d, XMLDoc xsl) {
        this(d.getRoot(), xsl);
    }

    public XMLDoc getTransformElement() {
        if (this.xsl == null) {
            return null;
        }
        DOMResult transformedResult = new DOMResult();
        this.getTransformedResult(transformedResult);
        Node transformedDoc = transformedResult.getNode();
        Node root = transformedDoc == null ? null : transformedDoc.getFirstChild();
        return root == null ? null : new XMLDoc((Document)transformedDoc);
    }

    private void getTransformedResult(Result transformedResult) {
        DOMSource mySrc = new DOMSource(this.elem);
        DOMSource xslSrc = new DOMSource((Node)((Object)this.xsl.getMemberDocument()));
        try {
            Transformer theTransformer = TransformerFactory.newInstance().newTransformer(xslSrc);
            theTransformer.transform(mySrc, transformedResult);
        }
        catch (TransformerException x) {
            this.log.error((Object)"error applying xsl transform ", (Throwable)x);
        }
    }

    @Override
    public void writeStream(OutputStream stream) {
        if (this.xsl != null && stream != null) {
            StreamResult transformedResult = new StreamResult(stream);
            this.getTransformedResult(transformedResult);
        }
    }
}

