/**
 * The CIP4 Software License, Version 1.0
 *
 * Copyright (c) 2001-2015 The International Cooperation for the Integration of 
 * Processes in  Prepress, Press and Postpress (CIP4).  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        The International Cooperation for the Integration of 
 *        Processes in  Prepress, Press and Postpress (www.cip4.org)"
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "CIP4" and "The International Cooperation for the Integration of 
 *    Processes in  Prepress, Press and Postpress" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact info@cip4.org.
 *
 * 5. Products derived from this software may not be called "CIP4",
 *    nor may "CIP4" appear in their name, without prior written
 *    permission of the CIP4 organization
 *
 * Usage of this software in commercial products is subject to restrictions. For
 * details please consult info@cip4.org.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNATIONAL COOPERATION FOR
 * THE INTEGRATION OF PROCESSES IN PREPRESS, PRESS AND POSTPRESS OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the The International Cooperation for the Integration 
 * of Processes in Prepress, Press and Postpress and was
 * originally based on software 
 * copyright (c) 1999-2001, Heidelberger Druckmaschinen AG 
 * copyright (c) 1999-2001, Agfa-Gevaert N.V. 
 *  
 * For more information on The International Cooperation for the 
 * Integration of Processes in  Prepress, Press and Postpress , please see
 * <http://www.cip4.org/>.
 *  
 * 
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.AttributeName;
import org.cip4.jdflib.core.ElementName;
import org.cip4.jdflib.core.JDFResourceLink.EnumUsage;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.JDFNode.EnumType;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResource.EnumResStatus;
import org.cip4.jdflib.resource.JDFResource.EnumResourceClass;
import org.cip4.jdflib.util.StringUtil;

/**
 * @author Rainer Prosi, Heidelberger Druckmaschinen walker for the various resource sets
 */
public class WalkSet extends WalkXElement
{
	/**
	 * 
	 */
	public WalkSet()
	{
		super();
	}

	/**
	 * @param xjdf
	 * @param jdf
	 * 
	 * @return the current parent node
	 */
	@Override
	public KElement walk(final KElement xjdf, final KElement jdf)
	{
		final JDFNode parentNode = (JDFNode) jdf;
		String procUsage = StringUtil.getNonEmpty(xjdf.getAttribute(AttributeName.PROCESSUSAGE));
		if (ProductHelper.PRODUCT.equals(procUsage))
		{
			if (!EnumType.Product.equals(parentNode.getEnumType()))
			{
				return null;
			}
		}
		return jdf;
	}

	/**
	 * @param xjdf
	 * @param jdf
	 * @return the created resource
	 */
	public KElement oldwalk(final KElement xjdf, final KElement jdf)
	{
		final JDFNode parentNode = (JDFNode) jdf;
		final JDFNode root = parentNode.getJDFRoot();
		EnumUsage inOut = EnumUsage.getEnum(xjdf.getAttribute(AttributeName.USAGE));
		String procUsage = StringUtil.getNonEmpty(xjdf.getAttribute(AttributeName.PROCESSUSAGE));
		if (ProductHelper.PRODUCT.equals(procUsage))
		{
			if (!EnumType.Product.equals(parentNode.getEnumType()))
			{
				return null;
			}
		}
		final String id = xjdf.getAttribute(AttributeName.ID, null, null);
		if (inOut == null && xjdfToJDFImpl.isHeuristicLink())
		{
			final String name = getJDFResName(xjdf);
			if (!ElementName.CONTACT.equals(name) && !ElementName.LAYOUTELEMENT.equals(name) && !ElementName.RUNLIST.equals(name) && !ElementName.COMPONENT.equals(name)
					&& !ElementName.COLORPOOL.equals(name) && !ElementName.MEDIA.equals(name) && !ElementName.EXPOSEDMEDIA.equals(name)
					&& parentNode.isValidLink(name, EnumUsage.Input, StringUtil.getNonEmpty(xjdf.getAttribute(AttributeName.PROCESSUSAGE, null, null))))
			{
				inOut = EnumUsage.Input;
			}
		}

		JDFResource r = null;
		final KElement idElem = root.getCreateResourcePool().getChildWithAttribute(null, AttributeName.ID, null, id, 0, true);
		if (idElem instanceof JDFResource)
		{
			r = (JDFResource) idElem;
		}
		else
		{
			r = (JDFResource) root.getChildWithAttribute(null, AttributeName.ID, null, id, 0, false);
			if (r != null)
			{
				final JDFResourcePool rp = root.getCreateResourcePool();
				if (!rp.equals(r.getParentNode_KElement()))
				{
					rp.moveElement(r, null);
				}
			}
		}
		if (r == null)
		{
			final String name = getJDFResName(xjdf);
			if (name != null)
			{
				String nsURI = StringUtil.getNonEmpty(xjdf.getNamespaceURI());
				r = root.addResource(name, null, null, null, null, nsURI, null);
				r.removeAttribute(AttributeName.STATUS); // don't want the default
			}
		}
		if (r != null)
		{
			r.setAttributes(xjdf);
			if (r.getResourceClass() == null)
			{
				final String name = StringUtil.leftStr(xjdf.getLocalName(), -3);
				r.setResourceClass("Parameter".equals(name) ? EnumResourceClass.Parameter : EnumResourceClass.Handling);
			}

			// not linked are also available - they will typically be referenced resources
			if (!r.hasAttribute(AttributeName.STATUS))
			{
				r.setResStatus(EnumUsage.Output.equals(inOut) ? EnumResStatus.Unavailable : EnumResStatus.Available, true);
			}

			r.removeAttribute(AttributeName.NAME);
			r.removeAttribute(AttributeName.USAGE);
		}
		return r;
	}

	/**
	 * 
	 * @param e
	 * @return
	 */
	protected String getJDFResName(final KElement e)
	{
		final SetHelper h = new SetHelper(e);
		final String name = h.getName();
		return name;
	}

	/**
	 * @see org.cip4.jdflib.elementwalker.BaseWalker#matches(org.cip4.jdflib.core.KElement)
	 * @param toCheck
	 * @return true if it matches
	 */
	@Override
	public boolean matches(final KElement toCheck)
	{
		final KElement parent = toCheck.getParentNode_KElement();
		final boolean bL1 = parent != null && (parent.getLocalName().equals(XJDFHelper.XJDF) || parent.getLocalName().equals("Product"));
		final String localName = toCheck.getLocalName();
		return bL1 && super.matches(toCheck) && localName.endsWith("Set")
				&& (toCheck.hasAttribute(AttributeName.NAME) || toCheck.getElement(StringUtil.leftStr(localName, -3)) != null);
	}

}