/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFCMYKColor;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.util.StringUtil;

public class JDFRGBColor
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public JDFRGBColor() {
        super(3);
    }

    @Deprecated
    public JDFRGBColor(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFRGBColor(String s) throws DataFormatException {
        super(s);
    }

    public static JDFRGBColor createRGBColor(String s) {
        if (s != null && s.length() >= 5) {
            try {
                return new JDFRGBColor(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFRGBColor(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFRGBColor(double r, double g, double b) {
        super(3);
        this.set(0, r);
        this.set(1, g);
        this.set(2, b);
    }

    public JDFRGBColor(double[] rgbArray) {
        this(rgbArray[0], rgbArray[1], rgbArray[2]);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() != 3) {
            throw new DataFormatException("wrong size:" + this.size());
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public double getR() {
        return this.doubleAt(0);
    }

    public void setR(double red) {
        this.set(0, red);
    }

    public double getG() {
        return this.doubleAt(1);
    }

    public void setG(double green) {
        this.set(1, green);
    }

    public double getB() {
        return this.doubleAt(2);
    }

    public void setB(double blue) {
        this.set(2, blue);
    }

    public String getHTMLColor() {
        int r = (int)(255.0 * this.getR());
        int g = (int)(255.0 * this.getG());
        int b = (int)(255.0 * this.getB());
        return StringUtil.sprintf("#%02x%02x%02x", r + "," + g + "," + b);
    }

    public JDFCMYKColor getCMYK() {
        return new JDFCMYKColor(JDFRGBColor.getCMYKArray(this.getR(), this.getG(), this.getB()));
    }

    public static double[] getCMYKArray(double r, double g, double b) {
        double k0 = r;
        if (b > k0) {
            k0 = b;
        }
        if (g > k0) {
            k0 = g;
        }
        double[] ret = new double[4];
        ret[3] = 1.0 - k0;
        if (k0 > 0.0) {
            ret[0] = (k0 - r) / k0;
            ret[1] = (k0 - g) / k0;
            ret[2] = (k0 - b) / k0;
        } else {
            ret[2] = 0.0;
            ret[1] = 0.0;
            ret[0] = 0.0;
        }
        return ret;
    }

    public static double[] getCMYKArray(int r, int g, int b) {
        return JDFRGBColor.getCMYKArray((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
    }
}

