/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.datatypes.JDFNumList;
import org.cip4.jdflib.util.ScaleUtil;

public class JDFRectangle
extends JDFNumList {
    private static final long serialVersionUID = 1L;

    public JDFRectangle() {
        super(4);
    }

    @Deprecated
    public JDFRectangle(Vector v) throws DataFormatException {
        super(v);
    }

    public JDFRectangle(String s) throws DataFormatException {
        super(s);
    }

    public static JDFRectangle createRectangle(String s) {
        if (s != null && s.length() >= 7) {
            try {
                return new JDFRectangle(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFRectangle(JDFRectangle rec) {
        super(4);
        this.setLlx(rec.getLlx());
        this.setLly(rec.getLly());
        this.setUrx(rec.getUrx());
        this.setUry(rec.getUry());
    }

    public JDFRectangle(JDFNumList nl) throws DataFormatException {
        super(nl);
    }

    public JDFRectangle(double llx, double lly, double urx, double ury) {
        super(4);
        this.setLlx(llx);
        this.setLly(lly);
        this.setUrx(urx);
        this.setUry(ury);
    }

    @Override
    public boolean isValid() throws DataFormatException {
        if (this.size() != 4) {
            throw new DataFormatException("Data format exception! wrong size: " + this.size());
        }
        for (Object o : this) {
            if (o instanceof Double) continue;
            throw new DataFormatException("Data format exception!");
        }
        return true;
    }

    public double getLlx() {
        return this.doubleAt(0);
    }

    public void setLlx(double x) {
        this.set(0, x);
    }

    public void setLlxMm(double mmX) {
        this.setLlx(ScaleUtil.mm2Dtp(mmX));
    }

    public double getLly() {
        return this.doubleAt(1);
    }

    public void setLly(double y) {
        this.set(1, y);
    }

    public void setLlyMm(double mmY) {
        this.setLly(ScaleUtil.mm2Dtp(mmY));
    }

    public double getUrx() {
        return this.doubleAt(2);
    }

    public void setUrx(double x) {
        this.set(2, x);
    }

    public void setUrxMm(double mmX) {
        this.setUrx(ScaleUtil.mm2Dtp(mmX));
    }

    public double getUry() {
        return this.doubleAt(3);
    }

    public void setUry(double y) {
        this.set(3, y);
    }

    public void setUryMm(double mmY) {
        this.setUry(ScaleUtil.mm2Dtp(mmY));
    }

    public double getWidth() {
        return Math.abs(this.getUrx() - this.getLlx());
    }

    public double getHeight() {
        return Math.abs(this.getUry() - this.getLly());
    }

    public boolean isGreater(JDFRectangle r) {
        return !this.equals(r) && this.getLlx() <= r.getLlx() && this.getLly() <= r.getLly() && this.getUrx() >= r.getUrx() && this.getUry() >= r.getUry();
    }

    public boolean isGreaterOrEqual(JDFRectangle r) {
        return this.getLlx() <= r.getLlx() && this.getLly() <= r.getLly() && this.getUrx() >= r.getUrx() && this.getUry() >= r.getUry();
    }

    public boolean isLess(JDFRectangle r) {
        return !this.equals(r) && this.getLlx() >= r.getLlx() && this.getLly() >= r.getLly() && this.getUrx() <= r.getUrx() && this.getUry() <= r.getUry();
    }

    public boolean isLessOrEqual(JDFRectangle r) {
        return this.getLlx() >= r.getLlx() && this.getLly() >= r.getLly() && this.getUrx() <= r.getUrx() && this.getUry() <= r.getUry();
    }
}

