/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.JDFRectangleRange;
import org.cip4.jdflib.util.StringUtil;

public class JDFRectangleRangeList
extends JDFRangeList {
    public static JDFRectangleRangeList createRectangleRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFRectangleRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFRectangleRangeList() {
    }

    public JDFRectangleRangeList(JDFRectangleRangeList rl) {
        this.rangeList = new Vector(rl.rangeList);
    }

    public JDFRectangleRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public boolean inRange(JDFRectangle x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            if (!((JDFRectangleRange)this.rangeList.elementAt(i)).inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString vs = new VString(zappedWS, " ");
        this.rangeList.clear();
        int size = vs.size();
        for (int i = 0; i < size; ++i) {
            if (size - i < 4) {
                throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
            }
            StringBuffer str = new StringBuffer(100);
            str.append(vs.elementAt(i)).append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i)).append(" ");
            String tildeToken = vs.elementAt(++i);
            str.append(tildeToken);
            if (tildeToken.indexOf("~") != -1) {
                if (size - i < 4) {
                    throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
                }
                str.append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i)).append(" ").append(vs.elementAt(++i));
            }
            try {
                JDFRectangleRange r = new JDFRectangleRange(str.toString());
                this.rangeList.addElement(r);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFRectangleRangeList.setString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFRectangleRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFRectangleRange x) {
        this.rangeList.addElement(x);
    }

    public void append(JDFRectangle x) {
        this.append(new JDFRectangleRange(x));
    }

    public void append(JDFRectangle xMin, JDFRectangle xMax) {
        this.append(new JDFRectangleRange(xMin, xMax));
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFRectangle> v = new Vector<JDFRectangle>();
        for (int i = 0; i < siz; ++i) {
            JDFRectangleRange r = (JDFRectangleRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFRectangle first = (JDFRectangle)v.elementAt(0);
        JDFRectangle last = (JDFRectangle)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            JDFRectangle value = (JDFRectangle)v.elementAt(j);
            JDFRectangle nextvalue = (JDFRectangle)v.elementAt(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isLess(last) && value.isLessOrEqual(nextvalue) || first.isGreater(last) && value.isGreaterOrEqual(nextvalue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFRectangle last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFRectangle> v = new Vector<JDFRectangle>();
        for (int i = 0; i < siz; ++i) {
            JDFRectangleRange r = (JDFRectangleRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFRectangle first = (JDFRectangle)v.elementAt(0);
        if (first.equals(last = (JDFRectangle)v.elementAt(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFRectangle value = (JDFRectangle)v.elementAt(j);
            JDFRectangle nextvalue = (JDFRectangle)v.elementAt(j + 1);
            if (first.isLess(last) && value.isLess(nextvalue) || first.isGreater(last) && value.isGreater(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

