/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComChannel;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class RemoveEmpty
extends BaseElementWalker {
    boolean zappElements = true;
    final JDFPart part = (JDFPart)new JDFDoc("Part").getRoot();

    public RemoveEmpty() {
        super(new BaseWalkerFactory());
        this.part.appendElement("foo");
        new BaseWalker(this.getFactory());
    }

    public void removEmpty(JDFNode n) {
        new UnLinkFinder().eraseUnlinked(n);
        this.removEmptyElement(n);
        new UnLinkFinder().eraseUnlinked(n);
    }

    public void removEmptyElement(KElement e) {
        this.walkTreeKidsFirst(e);
    }

    public void removEmptyAttributes(KElement e) {
        boolean keep = this.zappElements;
        this.zappElements = false;
        this.walkTreeKidsFirst(e);
        this.zappElements = keep;
    }

    public void setZappElements(boolean zappElements) {
        this.zappElements = zappElements;
    }

    public class WalkComChannel
    extends WalkResource {
        @Override
        protected VString getDummyAttributes() {
            VString v = super.getDummyAttributes();
            v.add("ChannelType");
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComChannel;
        }
    }

    public class WalkResource
    extends WalkElement {
        @Override
        protected VString getDummyAttributes() {
            VString v = super.getDummyAttributes();
            v.add("Class");
            v.add("Status");
            v.add("PartIDKeys");
            v.add("PartUsage");
            VString partAttribs = RemoveEmpty.this.part.knownAttributes();
            JDFElement foo = (JDFElement)RemoveEmpty.this.part.getElement("foo");
            VString fooAttribs = foo.knownAttributes();
            partAttribs.removeStrings(fooAttribs, 0);
            v.appendUnique(partAttribs);
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResource;
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            boolean hasGood = false;
            if (RemoveEmpty.this.zappElements) {
                VElement links;
                hasGood = this.walkAttributes(e1);
                JDFResource r = (JDFResource)e1;
                if (!hasGood && r.getLinksAndRefs(false, true) != null) {
                    hasGood = true;
                }
                if (!hasGood && (links = r.getLinksAndRefs(true, false)) != null) {
                    for (KElement e : links) {
                        JDFResourceLink rl = (JDFResourceLink)e;
                        RemoveEmpty.this.removEmptyElement(rl);
                        if (rl.getAmountPool() != null || rl.getPart(0) != null) {
                            hasGood = true;
                            break;
                        }
                        JDFAttributeMap map = rl.getAttributeMap();
                        map.removeKeys(super.getDummyAttributes());
                        map.remove("rRef");
                        map.remove("Usage");
                        if (map.isEmpty()) continue;
                        hasGood = true;
                        break;
                    }
                }
            }
            return hasGood ? e1 : super.walk(e1, trackElem);
        }
    }

    public class WalkComment
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String text = StringUtil.getNonEmpty(e.getText());
            if (text == null) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComment;
        }
    }

    public class WalkGeneralID
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String idUsage = ((JDFGeneralID)e).getIDUsage();
            String idValue = ((JDFGeneralID)e).getIDValue();
            if (StringUtil.getNonEmpty(idUsage) == null || StringUtil.getNonEmpty(idValue) == null) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFGeneralID;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(RemoveEmpty.this.getFactory());
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            boolean hasGood = this.walkAttributes(e1);
            if (RemoveEmpty.this.zappElements && e1.numChildElements_KElement(null, null) == 0 && e1.getText() == null && !hasGood) {
                e1.deleteNode();
                return null;
            }
            return e1;
        }

        protected boolean walkAttributes(KElement e1) {
            JDFAttributeMap map = e1.getAttributeMap();
            VString allKeys = map.getKeys();
            boolean hasGood = false;
            VString dummy = RemoveEmpty.this.zappElements ? this.getDummyAttributes() : null;
            for (String key : allKeys) {
                if (StringUtil.getNonEmpty(map.get(key)) == null) {
                    e1.removeAttribute(key);
                    continue;
                }
                if (!RemoveEmpty.this.zappElements || hasGood || dummy.contains(key)) continue;
                hasGood = true;
            }
            return hasGood;
        }

        protected VString getDummyAttributes() {
            VString dummy = new VString();
            dummy.add("ID");
            dummy.add("AgentName");
            dummy.add("AgentVersion");
            return dummy;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }
}

