/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.w3c.dom.Element;

public class XPathWalker
extends BaseElementWalker {
    public VString attNames = new VString("Name,ChannelType,ContactTypes,IDUsage", ",");
    public int method = 1;
    protected final PrintWriter writer;
    boolean bAttribute = false;
    boolean bElement = true;
    boolean bAttributeValue = false;
    boolean bDatatype = false;
    String separator = " = ";
    protected Set<String> pathsFound;

    public int walkAll(KElement e) {
        int n = this.walkTree(e, null);
        this.writer.flush();
        this.writer.close();
        return n;
    }

    public void setAttribute(boolean attribute) {
        this.bAttribute = attribute;
    }

    public void setAttributeValue(boolean attribute) {
        this.bAttributeValue = attribute;
    }

    public XPathWalker(File xpathOutput) throws FileNotFoundException {
        this(new PrintWriter(xpathOutput));
    }

    public XPathWalker(PrintWriter w) {
        super(new BaseWalkerFactory());
        this.writer = w;
        this.pathsFound = null;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public void setUnique(boolean unique) {
        this.pathsFound = unique ? new HashSet() : null;
    }

    public void setDatatype(boolean datatype) {
        this.bDatatype = datatype;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setBElement(boolean element) {
        this.bElement = element;
    }

    public class WalkAll
    extends BaseWalker {
        public WalkAll() {
            super(XPathWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            XPathBuilder xb = new XPathBuilder(e, XPathWalker.this.method, XPathWalker.this.attNames);
            String s = xb.buildXPath(null);
            if (XPathWalker.this.bElement && (XPathWalker.this.pathsFound == null || !XPathWalker.this.pathsFound.contains(s))) {
                XPathWalker.this.writer.println(s);
                if (XPathWalker.this.pathsFound != null) {
                    XPathWalker.this.pathsFound.add(s);
                }
            }
            if (XPathWalker.this.bAttribute) {
                VString vkeys = e.getAttributeVector_KElement();
                Collections.sort(vkeys);
                for (int i = 0; i < vkeys.size(); ++i) {
                    String key = vkeys.get(i);
                    String path = s + "/@" + key;
                    if (XPathWalker.this.pathsFound != null && XPathWalker.this.pathsFound.contains(path)) continue;
                    XPathWalker.this.writer.print(path);
                    String attribute = e.getAttribute_KElement(key);
                    if (XPathWalker.this.bAttributeValue) {
                        XPathWalker.this.writer.print(XPathWalker.this.separator + attribute);
                    }
                    if (XPathWalker.this.bDatatype && e instanceof JDFElement) {
                        this.writeDatatype((JDFElement)e, key);
                    }
                    XPathWalker.this.writer.println();
                    if (XPathWalker.this.pathsFound == null) continue;
                    XPathWalker.this.pathsFound.add(path);
                }
            }
            return e;
        }

        private void writeDatatype(JDFElement e, String key) {
            Element createdElement;
            AttributeInfo.EnumAttributeType type = e.getAtrType(key);
            XPathWalker.this.writer.print(XPathWalker.this.separator);
            if (type != null) {
                XPathWalker.this.writer.print(type.getName());
            } else if (e.knownElements().contains(key) && (createdElement = e.getOwnerDocument_KElement().createElement(key)) instanceof JDFElement && (type = ((JDFElement)createdElement).getAtrType("Actual")) != null) {
                XPathWalker.this.writer.print(type.getName());
            }
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }

    static class XPathBuilder {
        protected KElement elem;
        protected int methCountSiblings;
        protected VString attributeNames;

        public XPathBuilder(KElement _e, int countSiblings, VString attName) {
            this.elem = _e;
            this.methCountSiblings = countSiblings;
            this.attributeNames = attName;
        }

        public String buildXPath(String relativeTo) {
            int iB;
            int i;
            String path = this.elem.getNodeName();
            KElement parent = this.elem.getParentNode_KElement();
            boolean bAtt = false;
            if (this.methCountSiblings > 0 && this.attributeNames != null) {
                int size = this.attributeNames.size();
                for (i = 0; i < size; ++i) {
                    if (this.methCountSiblings != 3 || !this.elem.hasAttribute_KElement(this.attributeNames.get(i), null, false)) continue;
                    path = path + "[@" + this.attributeNames.get(i) + "=\"" + this.elem.getAttribute(this.attributeNames.get(i)) + "\"]";
                    bAtt = true;
                    break;
                }
            }
            if (!bAtt) {
                KElement e = parent != null ? parent.getElement(path, null, 0) : null;
                i = 1;
                while (e != null) {
                    if (e.equals(this.elem)) {
                        if (this.methCountSiblings <= 0) break;
                        path = path + "[" + Integer.toString(i) + "]";
                        break;
                    }
                    while ((e = e.getNextSiblingElement()) != null && !e.fitsName(path, null)) {
                    }
                    ++i;
                }
            }
            path = "/" + path;
            if (parent != null) {
                path = new XPathBuilder(parent, this.methCountSiblings, this.attributeNames).buildXPath(relativeTo) + path;
            }
            if (relativeTo != null && path.startsWith(relativeTo) && (path = "." + path.substring(relativeTo.length())).startsWith(".[") && (iB = path.indexOf("]")) > 0) {
                path = "." + path.substring(iB + 1);
            }
            return path;
        }
    }
}

