/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.fixversion.WalkResource;
import org.cip4.jdflib.resource.intent.JDFColorIntent;

public class WalkColorIntent
extends WalkResource {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFColorIntent;
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        this.processNumColors(e1);
        return super.walk(e1, trackElem);
    }

    private void processNumColors(KElement e1) {
        JDFColorIntent ci = (JDFColorIntent)e1;
        if (this.fixVersion.lessThanVersion(JDFElement.EnumVersion.Version_1_5)) {
            this.removeNumColors(ci);
        } else {
            this.extractNumColors(ci);
        }
    }

    private void extractNumColors(JDFColorIntent ci) {
        VString colors;
        JDFSeparationList colorsUsed = ci.getColorsUsed();
        VString vString = colors = colorsUsed == null ? null : colorsUsed.getSeparations();
        if (colors != null) {
            if (colors.containsAll(JDFSeparationList.SEPARATIONS_CMYK)) {
                ci.setNumColors(4);
                colorsUsed.removeSeparations(JDFSeparationList.SEPARATIONS_CMYK);
            } else if (colors.contains("Black")) {
                ci.setNumColors(1);
                colorsUsed.removeSeparation("Black");
            }
        }
    }

    private void removeNumColors(JDFColorIntent ci) {
        int nc = ci.getNumColors();
        if (nc == 1) {
            ci.getCreateColorsUsed().getCreateSeparation("Black");
        }
        if (nc == 4) {
            ci.getCreateColorsUsed().ensureSeparations(JDFSeparationList.SEPARATIONS_CMYK);
        }
        ci.removeAttribute("NumColors");
    }
}

