/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.fixversion.WalkResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFLayout;

public class WalkComponent
extends WalkResource {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFComponent;
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFComponent c = (JDFComponent)e1;
        if (this.fixVersion.version != null) {
            if (this.fixVersion.version.getValue() >= JDFElement.EnumVersion.Version_1_4.getValue()) {
                c.removeAttribute("IsWaste");
            }
            if (this.fixVersion.version.getValue() >= JDFElement.EnumVersion.Version_1_3.getValue()) {
                this.fixFromSourceSheet(c);
            } else {
                this.fixToSourceSheet(c);
            }
        }
        return super.walk(e1, trackElem);
    }

    private void fixToSourceSheet(JDFComponent c) {
        JDFLayout layout = c.getLayout();
        if (layout != null) {
            String sourcesheet = layout.getSheetName();
            c.setSourceSheet(sourcesheet);
            JDFRefElement layoutRef = (JDFRefElement)c.getElement_KElement("LayoutRef", null, 0);
            if (layoutRef != null) {
                layoutRef.removeChild("Part", null, 0);
            }
        }
    }

    private void fixFromSourceSheet(JDFComponent c) {
        if (c.hasAttribute("SourceSheet")) {
            String sourceSheet = c.getSourceSheet();
            JDFRefElement layoutRef = (JDFRefElement)c.getElement_KElement("LayoutRef", null, 0);
            if (layoutRef != null) {
                JDFLayout lo = (JDFLayout)layoutRef.getLinkRoot(layoutRef.getrRef());
                if (lo != null) {
                    lo.fixVersion(this.fixVersion.version);
                }
                layoutRef.setPartMap(new JDFAttributeMap("SheetName", sourceSheet));
                lo = (JDFLayout)layoutRef.getTarget();
                layoutRef.setPartMap(lo.getPartMap());
            }
            c.removeAttribute("SourceSheet");
        }
    }
}

