/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.elementwalker.StrippingConverter;
import org.cip4.jdflib.elementwalker.fixversion.FixVersionImpl;
import org.cip4.jdflib.elementwalker.fixversion.WalkResource;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFLayoutPreparationParams;
import org.cip4.jdflib.resource.JDFResource;

public class WalkLayoutPrep
extends WalkResource {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFLayoutPreparationParams;
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFLayoutPreparationParams lpp = (JDFLayoutPreparationParams)e1;
        if (lpp.isResourceRoot() && this.fixVersion.bLayoutPrepToStripping) {
            int i;
            VElement rls = lpp.getLinksAndRefs(true, false);
            if (rls == null) {
                return null;
            }
            rls.unify();
            VElement vn = new VElement();
            for (int i2 = 0; i2 < rls.size(); ++i2) {
                JDFResourceLink rl = (JDFResourceLink)rls.get(i2);
                vn.add(rl.getParentJDF());
            }
            vn.unify();
            if (vn.size() <= 0) {
                return null;
            }
            JDFNode node = (JDFNode)vn.get(0);
            StrippingConverter sc = lpp.convertToStripping(node);
            new FixVersionImpl(this.fixVersion).walkTree(sc.getAssembly(), null);
            new FixVersionImpl(this.fixVersion).walkTree(sc.getStrippingParams(), null);
            new FixVersionImpl(this.fixVersion).walkTree(sc.getBinderySignature(), null);
            for (i = 1; i < vn.size(); ++i) {
                JDFNode n = (JDFNode)vn.get(i);
                n.linkResource((JDFResource)sc.getAssembly(), JDFResourceLink.EnumUsage.Input, null);
                n.linkResource((JDFResource)sc.getStrippingParams(), JDFResourceLink.EnumUsage.Input, null);
            }
            for (i = 0; i < rls.size(); ++i) {
                rls.get(i).deleteNode();
            }
            return null;
        }
        return super.walk(e1, trackElem);
    }
}

