/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.util.ContainerUtil;

public abstract class BaseXJDFHelper {
    private static Log log;
    protected KElement theElement;

    protected BaseXJDFHelper() {
        if (log == null) {
            log = LogFactory.getLog(BaseXJDFHelper.class);
        }
    }

    public String getXPathValue(String xpath) {
        return this.theElement == null ? null : this.theElement.getXPathAttribute(xpath, null);
    }

    public KElement getXPathElement(String xpath) {
        return this.theElement == null ? null : this.theElement.getXPathElement(xpath);
    }

    public void reorder() {
    }

    public void setXPathValue(String xpath, String value) {
        if (this.theElement != null) {
            this.theElement.setXPathValue(xpath, value);
        }
    }

    public abstract void cleanUp();

    public KElement getRoot() {
        return this.theElement;
    }

    public KElement deleteNode() {
        KElement ret = this.theElement;
        if (this.theElement != null) {
            this.theElement.deleteNode();
            this.theElement = null;
        }
        return ret;
    }

    public boolean isEqual(BaseXJDFHelper other) {
        if (this.theElement == null) {
            return other == null || other.theElement == null;
        }
        return this.theElement.isEqual(other.theElement);
    }

    public String getID() {
        return this.getXPathValue("@ID");
    }

    public void setID(String newID) {
        this.setXPathValue("@ID", newID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 42;
        result = 31 * result + (this.theElement == null ? 0 : this.theElement.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseXJDFHelper other = (BaseXJDFHelper)obj;
        return ContainerUtil.equals(this.theElement, other.theElement);
    }
}

