/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Collection;
import java.util.Vector;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.AbstractXJDFSplit;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.StringUtil;

public class ProcessXJDFSplit
extends AbstractXJDFSplit {
    final Vector<VString> groups = new Vector();

    @Override
    public Collection<XJDFHelper> splitXJDF(XJDFHelper root) {
        Vector<VString> newTypes = this.splitTypes(root);
        Vector<XJDFHelper> ret = new Vector<XJDFHelper>();
        if (newTypes != null && newTypes.size() > 0) {
            for (VString types : newTypes) {
                XJDFHelper h = root.clone();
                h.setTypes(types);
                String jobPartID = root.getJobPartID();
                if (jobPartID == null) {
                    jobPartID = "Part_";
                }
                h.setJobPartID(jobPartID + StringUtil.setvString(types));
                h.setID(null);
                this.fixInOutLinks(h);
                ret.add(h);
            }
            this.consolidateExchangeResources(ret);
        } else {
            ret.add(root);
        }
        return ret;
    }

    protected Vector<VString> splitTypes(XJDFHelper root) {
        Vector<VString> ret = new Vector<VString>();
        VString types = this.calcTypes(root);
        if (types == null || types.size() <= 1) {
            return null;
        }
        while (types.size() > 0) {
            String first = types.get(0);
            VString overlap = null;
            for (VString group : this.groups) {
                if (group.contains(first) && (overlap = types.getOverlapping(group)) != null) break;
            }
            if (overlap == null) {
                overlap = new VString();
                overlap.add(first);
            }
            ret.add(overlap);
            types.removeAll(overlap);
        }
        return ret.size() == 0 ? null : ret;
    }

    protected VString calcTypes(XJDFHelper root) {
        VString types = root.getTypes();
        if (types == null) {
            types = new VString();
        }
        types.remove("Product");
        Vector<ProductHelper> productHelpers = root.getProductHelpers();
        if (productHelpers != null) {
            types.insertElementAt("Product", 0);
        }
        return types;
    }

    public void addGroup(VString group) {
        if (group != null && !group.isEmpty()) {
            this.groups.add(group);
            ContainerUtil.unify(this.groups);
        }
    }

    public String toString() {
        return "ProcessXJDFSplit [groups=" + this.groups + "]";
    }
}

