/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.HashMap;
import java.util.Map;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.util.StringUtil;

public class IDFinder
extends BaseElementWalker {
    final Map<String, IDPart> theMap = new HashMap<String, IDPart>();
    final Map<String, String> indexMap = new HashMap<String, String>();

    public IDFinder() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public Map<String, IDPart> getMap(KElement n) {
        this.theMap.clear();
        this.walkTree(n, null);
        return this.theMap;
    }

    private String getIndex(String procs) {
        String index = this.indexMap.get(procs);
        if (index == null) {
            index = StringUtil.rightStr("00" + this.indexMap.size(), 3);
            this.indexMap.put(procs, index);
        }
        return index;
    }

    public class WalkSet
    extends BaseWalker {
        public WalkSet() {
            super(IDFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String id = e.getAttribute("ID", null, null);
            if (id == null) {
                id = "IDF" + KElement.uniqueID(0);
                e.setID(id);
            }
            IDFinder.this.theMap.put(id, new IDPart(id, null));
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            if (!b) {
                return false;
            }
            return SetHelper.isSet(toCheck);
        }
    }

    public class WalkResource
    extends BaseWalker {
        public WalkResource() {
            super(IDFinder.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String id = e.getAttribute("ID", null, null);
            if (id == null) {
                id = e.generateDotID("ID", null);
                e.setID(id);
            }
            VElement vPart = e.getChildElementVector("Part", null, null, true, 0, false);
            String idParent = this.getParentID(e);
            IDFinder.this.theMap.put(id, new IDPart(idParent, vPart));
            return e;
        }

        private String getParentID(KElement e) {
            String idParent = e.getParentNode_KElement().getAttribute("ID", null, null);
            return idParent;
        }

        @Override
        public boolean matches(KElement toCheck) {
            boolean b = super.matches(toCheck);
            if (!b) {
                return false;
            }
            String localName = toCheck.getLocalName();
            return localName.equals("Resource") || localName.equals("Parameter");
        }
    }

    public class IDPart {
        protected String id;
        protected VJDFAttributeMap vMap = null;

        public IDPart(String idParent, VElement parts) {
            if (parts != null && parts.size() > 0) {
                KElement part = parts.get(0);
                if (part != null) {
                    String procs;
                    String productID = StringUtil.getNonEmpty(part.getAttribute("ProductPart"));
                    if (productID != null) {
                        idParent = idParent + "." + productID;
                    }
                    if ((procs = StringUtil.getNonEmpty(part.getAttribute("ProcessType"))) != null) {
                        idParent = idParent + "." + IDFinder.this.getIndex(procs);
                    }
                }
                this.vMap = new VJDFAttributeMap();
                for (KElement p : parts) {
                    JDFAttributeMap partMap = p.getAttributeMap();
                    partMap.remove("ProductPart");
                    partMap.remove("ProcessType");
                    this.vMap.add(partMap);
                }
                this.vMap.unify();
            }
            this.id = idParent;
        }

        public String toString() {
            return "IDPart: ID=" + this.id + " Map= " + this.vMap;
        }

        public String getID() {
            return this.id;
        }

        public VJDFAttributeMap getPartMap() {
            return this.vMap;
        }
    }
}

