/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.PostXJDFWalker;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResource;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFToXJDF
extends PackageElementWalker {
    public static final String rootName = "XJDF";
    public static final String rootJMF = "JMF";
    private boolean trackAudits = true;
    protected KElement newRoot = null;
    protected JDFNode oldRoot = null;
    protected Set<String> first = new HashSet<String>();
    private boolean bExplicitWaste = true;
    private boolean bRetainAll = false;
    private boolean bMergeLayout = true;
    private boolean bMergeLayoutPrep = true;
    private boolean bMergeRunList = true;
    private boolean bRetainSpawnInfo = false;
    private boolean bSingleNode = false;
    private boolean bUpdateVersion = true;
    private boolean bTypeSafeMessage = true;
    private boolean bAbstractMessage = false;
    private boolean bSpanAsAttribute = true;
    private boolean bIntentPartition = false;
    private boolean bParameterSet = false;
    private boolean wantProduct = true;
    private final JDFAttributeMap componentProductMap;
    private boolean bHTMLColor = false;
    private boolean bConvertTilde = true;
    String rootID = null;
    private boolean removeSignatureName = true;
    private boolean wantProcessList = false;

    public JDFToXJDF() {
        super(new BaseWalkerFactory());
        KElement.uniqueID(-1000);
        this.componentProductMap = new JDFAttributeMap();
    }

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkElement constructWalker = (WalkElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }

    protected String getClassName(JDFResource r) {
        WalkResource w = this.getWalker(r);
        return w == null ? null : w.getClassName(r);
    }

    protected WalkResource getWalker(JDFResource r) {
        if (r == null) {
            return null;
        }
        IWalker walker = this.theFactory.getWalker(r);
        return walker instanceof WalkResource ? (WalkResource)walker : null;
    }

    public void setTrackAudits(boolean trackAudits) {
        this.trackAudits = trackAudits;
    }

    public static String getSchemaURL() {
        return JDFElement.getSchemaURL(2, 0);
    }

    public boolean isExplicitWaste() {
        return this.bExplicitWaste;
    }

    public void setExplicitWaste(boolean bExplicitWaste) {
        this.bExplicitWaste = bExplicitWaste;
    }

    public boolean isParameterSet() {
        return this.bParameterSet;
    }

    public void setParameterSet(boolean bParameterSet) {
        this.bParameterSet = bParameterSet;
    }

    public boolean isWantProduct() {
        return this.wantProduct;
    }

    public void setWantProduct(boolean wantProduct) {
        this.wantProduct = wantProduct;
    }

    public void setWantProcessList(boolean bProcessList) {
        this.wantProcessList = bProcessList;
    }

    public boolean isRemoveSignatureName() {
        return this.removeSignatureName;
    }

    public void setRemoveSignatureName(boolean removeSignatureName) {
        this.removeSignatureName = removeSignatureName;
    }

    public KElement convert(KElement root) {
        if (root instanceof JDFJMF) {
            return this.makeNewJMF((JDFJMF)root);
        }
        if (root instanceof JDFNode) {
            return this.makeNewJDF((JDFNode)root, null);
        }
        return null;
    }

    public KElement makeNewJMF(JDFJMF jmf) {
        JDFJMF root = (JDFJMF)jmf.cloneNewDoc();
        this.prepareNewDoc(true);
        this.preFixVersion(root);
        this.walkTree(root, this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
        this.postWalk(true);
        return this.newRoot;
    }

    public KElement makeNewJDF(JDFNode node, VJDFAttributeMap vMap) {
        JDFNode root = (JDFNode)node.getJDFRoot().cloneNewDoc();
        this.rootID = node.getID();
        this.preFixVersion(root);
        String id = StringUtil.getNonEmpty(node.getID());
        JDFNode jDFNode = this.oldRoot = id == null ? root : (JDFNode)root.getChildWithAttribute(null, "ID", null, id, 0, false);
        if (this.oldRoot == null) {
            this.oldRoot = root;
        }
        this.prepareNewDoc(false);
        this.loopNodes(root);
        this.prepareRoot(root);
        this.postWalk(false);
        this.newRoot.getOwnerDocument_KElement().copyMeta(node.getOwnerDocument_KElement());
        return this.newRoot;
    }

    private void preFixVersion(JDFElement root) {
        FixVersion vers = new FixVersion(JDFElement.EnumVersion.Version_1_5);
        vers.setLayoutPrepToStripping(this.bMergeLayoutPrep);
        vers.setZappDeprecated(true);
        vers.walkTree(root, null);
    }

    private void postWalk(boolean bJMF) {
        PostXJDFWalker pw = new PostXJDFWalker((JDFElement)this.newRoot);
        pw.setMergeLayout(this.bMergeLayout);
        pw.setIntentPartition(this.bIntentPartition);
        pw.setRemoveSignatureName(this.removeSignatureName);
        pw.walkTreeKidsFirst(this.newRoot);
        if (!bJMF && this.trackAudits) {
            JDFAuditPool auditPool = (JDFAuditPool)this.newRoot.getCreateElement("AuditPool");
            auditPool.addCreated("XJDF Converter", null);
        }
        this.newRoot.eraseEmptyNodes(true);
    }

    private void prepareRoot(JDFNode node) {
        if (node != null) {
            node.ensureLink(node.getInheritedCustomerInfo(null), JDFResourceLink.EnumUsage.Input, null);
            node.ensureLink(node.getInheritedNodeInfo(null), JDFResourceLink.EnumUsage.Input, null);
        }
    }

    private void loopNodes(JDFNode node) {
        this.walkTree(node, this.newRoot);
    }

    private void prepareNewDoc(boolean bJMF) {
        JDFDoc newDoc = new JDFDoc(bJMF ? (this.bTypeSafeMessage ? "XJMF" : rootJMF) : rootName, JDFElement.EnumVersion.Version_2_0);
        newDoc.setInitOnCreate(false);
        this.newRoot = newDoc.getRoot();
        this.newRoot.setNamespaceURI(JDFToXJDF.getSchemaURL());
        this.first = new HashSet<String>();
    }

    protected void putComponentProduct(String compID, String productID) {
        this.componentProductMap.put(compID, productID);
    }

    protected String getProduct(String compID) {
        return this.componentProductMap.get(compID);
    }

    public static String getExtension() {
        return rootName.toLowerCase();
    }

    public void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        new MultiJDFToXJDF().saveZip(fileName, rootNode, replace);
    }

    public Vector<XJDFHelper> getXJDFs(JDFNode root) {
        return new MultiJDFToXJDF().getXJDFs(root);
    }

    protected static VJDFAttributeMap getPartMapVector(KElement res) {
        VJDFAttributeMap omaMaps = null;
        VElement parts = res.getChildElementVector("Part", null, null, true, 0, false);
        if (parts != null && parts.size() > 0) {
            omaMaps = new VJDFAttributeMap();
            for (int i = 0; i < parts.size(); ++i) {
                omaMaps.add(((JDFPart)parts.get(i)).getPartMap());
            }
        }
        return omaMaps;
    }

    @Deprecated
    public void retainAll() {
        this.setRetainAll(true);
    }

    public void setUpdateVersion(boolean bUpdateVersion) {
        this.bUpdateVersion = bUpdateVersion;
    }

    public boolean isMergeLayout() {
        return this.bMergeLayout;
    }

    public void setMergeLayout(boolean bMergeLayout) {
        this.bMergeLayout = bMergeLayout;
    }

    public boolean isMergeLayoutPrep() {
        return this.bMergeLayoutPrep;
    }

    public void setMergeLayoutPrep(boolean bMergeLayoutPrep) {
        this.bMergeLayoutPrep = bMergeLayoutPrep;
    }

    public boolean isMergeRunList() {
        return this.bMergeRunList;
    }

    public void setMergeRunList(boolean bMergeRunList) {
        this.bMergeRunList = bMergeRunList;
    }

    public boolean isRetainSpawnInfo() {
        return this.bRetainSpawnInfo;
    }

    public void setRetainSpawnInfo(boolean bRetainSpawnInfo) {
        this.bRetainSpawnInfo = bRetainSpawnInfo;
    }

    public boolean isSingleNode() {
        return this.bSingleNode;
    }

    public void setSingleNode(boolean bSingleNode) {
        this.bSingleNode = bSingleNode;
    }

    public boolean isUpdateVersion() {
        return this.bUpdateVersion;
    }

    public boolean isTypeSafeMessage() {
        return this.bTypeSafeMessage;
    }

    public void setTypeSafeMessage(boolean bTypeSafeMessage) {
        this.bTypeSafeMessage = bTypeSafeMessage;
    }

    public boolean isAbstractMessage() {
        return this.bAbstractMessage;
    }

    public void setAbstractMessage(boolean bAbstractMessage) {
        this.bAbstractMessage = bAbstractMessage;
    }

    public boolean isSpanAsAttribute() {
        return this.bSpanAsAttribute;
    }

    public void setSpanAsAttribute(boolean bSpanAsAttribute) {
        this.bSpanAsAttribute = bSpanAsAttribute;
    }

    public boolean isIntentPartition() {
        return this.bIntentPartition;
    }

    public void setIntentPartition(boolean bIntentPartition) {
        this.bIntentPartition = bIntentPartition;
    }

    public boolean isHTMLColor() {
        return this.bHTMLColor;
    }

    public void setHTMLColor(boolean bHTMLColor) {
        this.bHTMLColor = bHTMLColor;
    }

    public boolean isConvertTilde() {
        return this.bConvertTilde;
    }

    public void setConvertTilde(boolean bConvertTilde) {
        this.bConvertTilde = bConvertTilde;
    }

    protected String getSetName(JDFResource r) {
        WalkResource w = this.getWalker(r);
        return w == null ? null : w.getXJDFName(r);
    }

    protected boolean isProductResource(JDFResource linkTarget) {
        WalkResource w = this.getWalker(linkTarget);
        return w.isProductResource(linkTarget);
    }

    public boolean isRetainAll() {
        return this.bRetainAll;
    }

    public void setRetainAll(boolean bRetainAll) {
        this.bRetainAll = bRetainAll;
        if (bRetainAll) {
            this.setAbstractMessage(false);
            this.setConvertTilde(false);
            this.setExplicitWaste(false);
            this.setHTMLColor(false);
            this.setMergeLayout(false);
            this.setMergeLayoutPrep(false);
            this.setMergeRunList(false);
            this.setRemoveSignatureName(false);
            this.setRetainSpawnInfo(true);
            this.setTypeSafeMessage(false);
            this.setUpdateVersion(false);
        }
    }

    public boolean isWantProcessList() {
        return this.wantProcessList;
    }

    private class MultiJDFToXJDF {
        void saveZip(String fileName, JDFNode rootNode, boolean replace) {
            JDFToXJDF.this.setSingleNode(true);
            File file = new File(fileName);
            if (file.canRead()) {
                if (replace) {
                    file.delete();
                } else {
                    throw new JDFException("output file exists: " + file.getPath());
                }
            }
            try {
                Vector<XJDFHelper> v = this.getXJDFs(rootNode);
                BufferedOutputStream fos = FileUtil.getBufferedOutputStream(new File(fileName));
                ZipOutputStream zos = new ZipOutputStream(fos);
                for (XJDFHelper h : v) {
                    try {
                        String nam = h.getJobPartID() + "." + JDFToXJDF.rootName;
                        ZipEntry ze = new ZipEntry(nam);
                        zos.putNextEntry(ze);
                        h.writeToStream(zos);
                        zos.closeEntry();
                    }
                    catch (ZipException x) {
                        JDFToXJDF.this.log.error((Object)"oops: ", (Throwable)x);
                    }
                    catch (IOException x) {
                        JDFToXJDF.this.log.error((Object)"oops: ", (Throwable)x);
                    }
                }
                zos.close();
            }
            catch (IOException x) {
                JDFToXJDF.this.log.error((Object)"oops: ", (Throwable)x);
            }
        }

        MultiJDFToXJDF() {
        }

        Vector<XJDFHelper> getXJDFs(JDFNode root) {
            if (root == null) {
                return null;
            }
            JDFToXJDF.this.setSingleNode(true);
            Vector<XJDFHelper> vRet = new Vector<XJDFHelper>();
            VElement v = this.getProcessNodes(root);
            boolean keepProduct = JDFToXJDF.this.wantProduct;
            JDFToXJDF.this.wantProduct = true;
            if ("Product".equals(root.getType())) {
                XJDFHelper xjdfHelper = this.convertSingle(root);
                vRet.add(xjdfHelper);
            }
            JDFToXJDF.this.wantProduct = false;
            for (KElement n : v) {
                XJDFHelper xjdfHelper = this.convertSingle(n);
                vRet.add(xjdfHelper);
            }
            JDFToXJDF.this.wantProduct = keepProduct;
            return vRet;
        }

        private XJDFHelper convertSingle(KElement n) {
            KElement xjdf = JDFToXJDF.this.makeNewJDF((JDFNode)n, null);
            XJDFHelper xjdfHelper = new XJDFHelper(xjdf);
            xjdfHelper.cleanUp();
            return xjdfHelper;
        }

        VElement getProcessNodes(JDFNode rootNode) {
            VElement v = rootNode.getvJDFNode(null, null, false);
            for (int i = v.size() - 1; i >= 0; --i) {
                JDFNode n = (JDFNode)v.elementAt(i);
                if (!n.isProcessNode()) {
                    v.remove(i);
                    continue;
                }
                this.ensureJobPartID(i, n);
            }
            return v;
        }

        private void ensureJobPartID(int i, JDFNode n) {
            String nam = n.getJobPartID(false);
            if (StringUtil.getNonEmpty(nam) == null) {
                nam = "Part_" + i;
                n.setJobPartID(nam);
            }
        }
    }
}

