/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.HashSet;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

class JDFToXJDFDataCache {
    private static JDFToXJDFDataCache theCache;
    private final VString elemAttribs;
    private final HashSet<String> inlineSet;
    private final VString resAttribs = this.generateResourceAttributes();
    private final VString amountAttribs;

    private static JDFToXJDFDataCache getCache() {
        if (theCache == null) {
            theCache = new JDFToXJDFDataCache();
        }
        return theCache;
    }

    private JDFToXJDFDataCache() {
        this.elemAttribs = this.generateElementAttributes();
        this.inlineSet = this.generateInlineSet();
        this.amountAttribs = new VString("Amount,ActualAmount,MinAmount,MaxAmount", ",");
    }

    private VString generateElementAttributes() {
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        return dummyResPool.knownAttributes();
    }

    private HashSet<String> generateInlineSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("ObjectResolution");
        set.add("BarcodeCompParams");
        set.add("BarcodeReproParams");
        set.add("ComChannel");
        set.add("InterpretedPDLData");
        set.add("ByteMap");
        set.add("Address");
        set.add("CostCenter");
        set.add("Company");
        set.add("Person");
        set.add("Device");
        set.add("DeviceNSpace");
        set.add("ColorantAlias");
        set.add("GlueLine");
        set.add("GlueApplication");
        set.add("CIELABMeasuringField");
        set.add("RegisterMark");
        set.add("FitPolicy");
        set.add("CutBlock");
        set.add("Employee");
        set.add("ElementColorParams");
        set.add("Cut");
        set.add("PDLResourceAlias");
        set.add("HoleList");
        set.add("Hole");
        set.add("MISDetails");
        set.add("HoleLine");
        set.add("JobField");
        set.add("AutomatedOverPrintParams");
        set.add("ExternalImpositionTemplate");
        set.add("ProductionPath");
        set.add("Shape");
        set.add("ScavengerArea");
        set.add("TrapRegion");
        set.add("TransferCurve");
        set.add("ColorControlStrip");
        set.add("LayerList");
        set.add("PageCondition");
        set.add("ContentObject");
        set.add("MarkObject");
        set.add("LayerDetails");
        set.add("FileSpec");
        set.add("IdentificationField");
        return set;
    }

    private VString generateResourceAttributes() {
        VString resAttribs = new VString();
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        JDFResource intRes = dummyResPool.appendResource("intent", JDFResource.EnumResourceClass.Intent, null);
        JDFResource physRes = dummyResPool.appendResource("physical", JDFResource.EnumResourceClass.Consumable, null);
        JDFResource paramRes = dummyResPool.appendResource("param", JDFResource.EnumResourceClass.Parameter, null);
        JDFPart part = (JDFPart)dummyResPool.appendElement("Part");
        resAttribs = paramRes.knownAttributes();
        resAttribs.appendUnique(physRes.knownAttributes());
        resAttribs.appendUnique(intRes.knownAttributes());
        resAttribs.appendUnique(part.knownAttributes());
        return resAttribs;
    }

    static VString getElemAttribs() {
        return JDFToXJDFDataCache.getCache().elemAttribs;
    }

    static HashSet<String> getInlineSet() {
        return JDFToXJDFDataCache.getCache().inlineSet;
    }

    static VString getResAttribs() {
        return JDFToXJDFDataCache.getCache().resAttribs;
    }

    static VString getAmountAttribs() {
        return JDFToXJDFDataCache.getCache().amountAttribs;
    }
}

