/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.util.Vector;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.util.StringUtil;

class ProcessListToPartition {
    private final XJDFHelper xjdfHelper;
    private final VElement processes;

    ProcessListToPartition(XJDFHelper xjdfHelper) {
        this.xjdfHelper = xjdfHelper;
        KElement list = xjdfHelper.getXPathElement("ProcessList");
        this.processes = list == null ? null : list.getChildElementVector("Process", null);
    }

    void evaluateProcessList() {
        VElement processes;
        KElement list = this.xjdfHelper.getXPathElement("ProcessList");
        VElement vElement = processes = list == null ? null : list.getChildElementVector("Process", null);
        if (processes == null) {
            return;
        }
        Vector<SetHelper> nodeInfos = this.xjdfHelper.getSets("NodeInfo", JDFResourceLink.EnumUsage.Input);
        if (nodeInfos == null || nodeInfos.size() <= 1) {
            return;
        }
        SetHelper keepNodeInfo = nodeInfos.get(0);
        keepNodeInfo.setProcessUsage("Process");
    }

    private String getTypesForNI(SetHelper nodeInfo) {
        String id = nodeInfo.getID();
        for (KElement process : this.processes) {
            if (!StringUtil.hasToken(process.getAttribute("Input", null, null), id, null, 0)) continue;
            return process.getAttribute("Types");
        }
        return null;
    }
}

