/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResLink;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;

public class WalkColorIntentResLink
extends WalkResLink {
    @Override
    protected VElement setResource(JDFElement rl, JDFResource linkTarget, KElement xjdf) {
        VElement v = super.setResource(rl, linkTarget, xjdf);
        VString frontBack = new VString("ColorsUsed Coatings ColorStandard Coverage", null);
        KElement thecolorIntent = null;
        for (KElement e1 : v) {
            String surface;
            JDFPart part = (JDFPart)e1.getElement("Part");
            KElement colorIntent = e1.getElement("ColorIntent");
            if (thecolorIntent == null) {
                thecolorIntent = colorIntent;
            }
            JDFAutoPart.EnumSide side = part == null ? null : part.getSide();
            String string = surface = side == null ? "Both" : side.getName();
            if (thecolorIntent == null) continue;
            KElement surfaceColor = thecolorIntent.getCreateChildWithAttribute("SurfaceColor", "Surface", null, surface, 0);
            this.fixNumColors(surfaceColor, colorIntent);
            if (part != null) {
                part.deleteNode();
            }
            for (String att : frontBack) {
                String attVal = colorIntent.getAttribute(att, null, null);
                if (attVal == null) continue;
                surfaceColor.setAttribute(att, attVal);
                thecolorIntent.removeAttribute(att);
            }
        }
        return v;
    }

    private void fixNumColors(KElement surfaceColor, KElement colorIntent) {
        int nCols = colorIntent.getIntAttribute("NumColors", null, -1);
        if (nCols >= 0) {
            String surface;
            KElement parentCI = surfaceColor.getParentNode_KElement();
            JDFXYPair xy = JDFXYPair.createXYPair(parentCI.getAttribute("NumColors"));
            if (xy == null) {
                xy = new JDFXYPair(0.0, 0.0);
            }
            if ("Both".equals(surface = surfaceColor.getAttribute("Surface")) || "Front".equals(surface)) {
                xy.setX(nCols);
            }
            if ("Both".equals(surface) || "Back".equals(surface)) {
                xy.setY(nCols);
            }
            parentCI.setAttribute("NumColors", xy.toString());
        }
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement e = super.walk(jdf, xjdf);
        return e;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && "ColorIntentLink".equals(toCheck.getLocalName());
    }
}

