/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResource;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.StringUtil;

public class WalkEmployee
extends WalkResource {
    @Override
    protected String getXJDFName(KElement jdf) {
        return "Contact";
    }

    @Override
    public boolean matches(KElement toCheck) {
        return !this.jdfToXJDF.isRetainAll() && toCheck instanceof JDFEmployee;
    }

    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement parent = jdf.getParentNode_KElement();
        if (parent instanceof JDFAudit || parent instanceof JDFMessage) {
            JDFEmployee emp = (JDFEmployee)jdf;
            String personalID = StringUtil.getNonEmpty(emp.getPersonalID());
            xjdf.setAttribute("PersonalID", personalID);
            String author = StringUtil.getNonEmpty(emp.getDescriptiveName());
            xjdf.setAttribute("Author", author);
            return null;
        }
        if (parent instanceof JDFJMF) {
            return null;
        }
        KElement e = this.moveToContact(jdf);
        return super.walk(e, xjdf);
    }

    public KElement moveToContact(KElement jdfEmployee) {
        JDFContact contact = (JDFContact)this.safeRename(jdfEmployee, "Contact", true);
        contact.setContactTypes("Employee");
        contact.renameAttribute("PersonalID", "ProductID", null, null);
        contact.renameAttribute("Roles", "ContactTypeDetails", null, null);
        return contact;
    }
}

