/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoGeneralID;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAncestorPool;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class WalkJDF
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        if (this.jdfToXJDF.first.contains(jdf.getID()) || this.jdfToXJDF.isSingleNode() && this.jdfToXJDF.first.size() > 0) {
            return null;
        }
        JDFNode node = (JDFNode)jdf;
        boolean matchesID = this.matchesRootID(node);
        if (matchesID) {
            this.prepareRoot(node, xjdf);
            this.jdfToXJDF.first.add(jdf.getID());
            return xjdf;
        }
        JDFNode nodeKid = node.getChildJDFNode(this.jdfToXJDF.rootID, false);
        if (nodeKid != null) {
            this.jdfToXJDF.walkTree(nodeKid, xjdf);
        }
        return null;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFNode;
    }

    void prepareRoot(JDFNode node, KElement newRootP) {
        if (JDFNode.EnumType.Product.equals((Object)node.getEnumType()) && node.getParentJDF() != null && !this.jdfToXJDF.first.isEmpty()) {
            return;
        }
        JDFNodeInfo ni = node.getCreateNodeInfo();
        VElement niLeaves = ni.getLeaves(false);
        for (KElement leaf : niLeaves) {
            JDFNodeInfo niLeaf = (JDFNodeInfo)leaf;
            JDFAttributeMap map = niLeaf.getPartMap();
            niLeaf.setNodeStatus(node.getPartStatus(map, 0));
            niLeaf.setNodeStatusDetails(StringUtil.getNonEmpty(node.getPartStatusDetails(map)));
        }
        if (this.jdfToXJDF.rootID.equals(node.getID())) {
            this.setRootAttributes(node, newRootP);
        }
    }

    private void setRootAttributes(JDFNode node, KElement newRootP) {
        newRootP.setXMLComment("Preliminary prototype version: using: " + JDFAudit.getStaticAgentName() + " " + JDFAudit.getStaticAgentVersion());
        newRootP.setAttribute("JobID", node.getJobID(true));
        String types = newRootP.getAttribute("Types", null, null);
        newRootP.setAttributes(node);
        this.removeUnused(newRootP);
        if (this.jdfToXJDF.isUpdateVersion()) {
            newRootP.setAttribute("Version", "2.0");
            newRootP.setAttribute("MaxVersion", "2.0");
            newRootP.setID(null);
        }
        this.updateTypes(newRootP, types);
        this.namedFeaturesToGeneralID(node, newRootP);
        this.updateSpawnInfo(node, newRootP);
    }

    private void namedFeaturesToGeneralID(JDFNode node, KElement newRootP) {
        if (node.hasAttribute("NamedFeatures")) {
            VString vnf = node.getNamedFeatures();
            for (int i = 0; i < vnf.size(); i += 2) {
                JDFGeneralID gi = (JDFGeneralID)newRootP.appendElement("GeneralID");
                gi.setIDUsage(vnf.get(i));
                gi.setIDValue(vnf.get(i + 1));
                gi.setDataType(JDFAutoGeneralID.EnumDataType.NMTOKEN);
                gi.setDescriptiveName("Copy from NamedFeatures");
            }
            newRootP.removeAttribute("NamedFeatures");
        }
    }

    @Override
    protected void removeUnused(KElement xjdfElement) {
        xjdfElement.removeAttribute("Status");
        xjdfElement.removeAttribute("StatusDetails");
        xjdfElement.removeAttribute("Activation");
        xjdfElement.removeAttribute("Template");
        super.removeUnused(xjdfElement);
    }

    private void updateTypes(KElement newRootP, String types) {
        if (!newRootP.hasAttribute("Types")) {
            newRootP.renameAttribute("Type", "Types", null, null);
        } else {
            newRootP.removeAttribute("Type");
        }
        VString t1 = StringUtil.tokenize(types, null, false);
        VString t2 = StringUtil.tokenize(newRootP.getAttribute("Types"), null, false);
        t1.removeStrings("Product", 0);
        t1.appendUnique(t2);
        t1.removeStrings("ProcessGroup", 0);
        t1.removeStrings("Combined", 0);
        newRootP.setAttribute("Types", t1, null);
    }

    private void updateSpawnInfo(JDFNode node, KElement newRootP) {
        if ("SpawnInfo" != null && newRootP.hasAttribute("SpawnID")) {
            VJDFAttributeMap vParts;
            KElement spawnInfo = newRootP.appendElement("SpawnInfo", "www.cip4.org/SpawnInfo");
            spawnInfo.moveAttribute("SpawnID", newRootP, null, null, null);
            JDFAncestorPool ancestorPool = node.getAncestorPool();
            if (ancestorPool != null && (vParts = ancestorPool.getPartMapVector()) != null) {
                int size = vParts.size();
                for (int i = 0; i < size; ++i) {
                    spawnInfo.appendElement("Part").setAttributes(vParts.elementAt(i));
                }
            }
        }
    }
}

