/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.util.StringUtil;

public class WalkResLink
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFResourceLink rl = (JDFResourceLink)jdf;
        JDFResource linkTarget = rl.getLinkRoot();
        JDFNode n = rl.getParentJDF();
        if (linkTarget == null) {
            return null;
        }
        if (n.isProduct()) {
            if (linkTarget instanceof JDFComponent || !this.jdfToXJDF.isWantProduct() && !this.matchesRootID(n)) {
                return null;
            }
            if (this.jdfToXJDF.isProductResource(linkTarget)) {
                KElement product = xjdf.getCreateElement("ProductList").getCreateElement("Product", null, -1);
                this.setResource(rl, linkTarget, product);
            } else {
                rl.setProcessUsage("Product");
                this.setResource(rl, linkTarget, this.jdfToXJDF.newRoot);
            }
        } else {
            if (!this.jdfToXJDF.isSingleNode()) {
                this.setProcess(rl);
            }
            this.setResource(rl, linkTarget, this.jdfToXJDF.newRoot);
        }
        return null;
    }

    private void setProcess(JDFResourceLink rl) {
        if (!this.jdfToXJDF.isWantProcessList() || rl == null) {
            return;
        }
        KElement process = this.getProcess(rl);
        this.setLink(process, rl);
    }

    private void setLink(KElement process, JDFResourceLink rl) {
        String usageName;
        if (rl == null || process == null) {
            return;
        }
        JDFResourceLink.EnumUsage usage = rl.getUsage();
        String string = usageName = usage == null ? null : usage.getName();
        if (usageName != null) {
            process.appendAttribute(usageName, rl.getrRef(), null, " ", true);
        }
    }

    private KElement getProcess(JDFResourceLink rl) {
        JDFNode parent = rl.getParentJDF();
        if (parent == null || parent.isProduct()) {
            return null;
        }
        if (parent.getElement("JDF") != null) {
            return null;
        }
        String jobPartID = this.getJobPartID(parent);
        if (jobPartID == null) {
            return null;
        }
        KElement processList = this.jdfToXJDF.newRoot.getCreateElement("ProcessList", null, 0);
        KElement process = processList.getChildWithAttribute("Process", "JobPartID", null, jobPartID, 0, true);
        if (process == null) {
            JDFNode grandparent;
            process = processList.appendElement("Process");
            process.setAttribute("JobPartID", jobPartID);
            if (parent.hasAttribute("Types")) {
                process.copyAttribute("Types", parent);
            } else {
                process.copyAttribute("Types", parent, "Type", null, null);
            }
            process.copyAttribute("Category", parent);
            process.copyAttribute("DescriptiveName", parent);
            for (grandparent = parent.getParentJDF(); grandparent != null && !grandparent.isProduct(); grandparent = grandparent.getParentJDF()) {
            }
            if (grandparent != null) {
                process.setAttribute("Parent", this.getJobPartID(grandparent));
            }
        }
        return process;
    }

    private String getJobPartID(JDFNode parent) {
        String jobPartID = StringUtil.getNonEmpty(parent.getJobPartID(false));
        if (jobPartID == null) {
            jobPartID = StringUtil.getNonEmpty(parent.getID());
        }
        return jobPartID;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFResourceLink && !(toCheck instanceof JDFPartAmount);
    }

    @Override
    protected VElement setResource(JDFElement rl, JDFResource linkTarget, KElement xRoot) {
        VElement newResources = super.setResource(rl, linkTarget, xRoot);
        if ("XJDF".equals(xRoot.getLocalName())) {
            this.setNodePartitions(rl, newResources);
        }
        return newResources;
    }

    private void setNodePartitions(JDFElement rl, VElement newResources) {
        if (newResources != null && newResources.size() > 0 && !this.jdfToXJDF.isWantProcessList() && !this.jdfToXJDF.isSingleNode()) {
            JDFNode parentNode = rl.getParentJDF();
            JDFNode parentProduct = parentNode.getParentProduct();
            for (KElement newResource : newResources) {
                String typesString;
                PartitionHelper ph = new PartitionHelper(newResource);
                VJDFAttributeMap partMaps = ph.getPartMapVector();
                boolean bChange = false;
                if (parentProduct != null) {
                    partMaps.put("ProductPart", parentProduct.getID());
                    bChange = true;
                }
                if (parentNode != parentProduct && (typesString = StringUtil.getNonEmpty(parentNode.getTypesString())) != null) {
                    partMaps.put("ProcessType", typesString);
                    bChange = true;
                }
                if (!bChange) continue;
                ph.setPartMapVector(partMaps);
            }
        }
    }
}

