/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXJDFResource;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPageList;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFPageData;

public class WalkContentResource
extends WalkXJDFResource {
    @Override
    protected String getJDFResName(SetHelper sh) {
        return "PageList";
    }

    @Override
    protected KElement createPartition(KElement e, JDFResource jdfRes, JDFPart part, JDFNode theNode) {
        JDFAttributeMap restMap = this.getPartMap(part);
        if (restMap.size() > 0) {
            return super.createPartition(e, jdfRes, part, theNode);
        }
        JDFPageList pageList = (JDFPageList)jdfRes;
        String pages = part.getAttribute("PageNumber");
        KElement pd = pageList.getChildWithAttribute("PageData", "PageIndex", null, pages, 0, true);
        if (pd != null) {
            return null;
        }
        JDFPageData rPageData = pageList.appendPageData();
        rPageData.copyAttribute("PageIndex", part, "PageNumber", null, null);
        JDFResourceLink rll = theNode.getLink((JDFResource)pageList, null);
        if (rll != null) {
            rll.removeChildren("Part", null, null);
        }
        pageList.removeFromAttribute("PartIDKeys", "PageNumber", null, " ", -1);
        return rPageData;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return PartitionHelper.isAsset(toCheck, "Content");
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        KElement rPart = super.walk(e, trackElem);
        if (rPart != null) {
            rPart.removeAttribute("Status");
        }
        return rPart;
    }

    @Override
    JDFAttributeMap getPartMap(JDFPart part) {
        JDFAttributeMap partMap = super.getPartMap(part);
        partMap.remove("PageNumber");
        return partMap;
    }
}

