/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.XJDFToJDFConverter;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDFResource
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdfRes, KElement jdfNode) {
        JDFPart part;
        JDFNode theNode = this.getNode(xjdfRes, jdfNode);
        JDFResource res = this.getResourceRoot(theNode, xjdfRes);
        KElement newPartitionElement = this.createPartition(xjdfRes, res, part = (JDFPart)xjdfRes.getElement("Part"), theNode);
        if (newPartitionElement == null) {
            return null;
        }
        JDFAttributeMap map = this.getResMap(xjdfRes);
        if (newPartitionElement instanceof JDFResource) {
            JDFResource newPartition = (JDFResource)newPartitionElement;
            JDFResourceLink rl = theNode.getLink(newPartition, null);
            rl = this.ensureLink(theNode, newPartition, rl);
            JDFAttributeMap partMap = this.getPartMap(part);
            this.handleAmountPool(xjdfRes, partMap, map, rl);
        }
        newPartitionElement.setAttributes(map);
        return newPartitionElement;
    }

    protected String getJDFResName(SetHelper sh) {
        String name = sh.getName();
        return name;
    }

    private JDFResource getResourceRoot(JDFNode theNode, KElement xjdfRes) {
        JDFNode newRoot = theNode.getJDFRoot();
        PartitionHelper ph = new PartitionHelper(xjdfRes);
        SetHelper sh = ph.getSet();
        String name = this.getJDFResName(sh);
        JDFResourceLink.EnumUsage inOut = sh.getUsage();
        String processUsage = sh.getProcessUsage();
        if (!(inOut != null || !this.xjdfToJDFImpl.isHeuristicLink() || "Contact".equals(name) || "LayoutElement".equals(name) || "RunList".equals(name) || "Component".equals(name) || "ColorPool".equals(name) || "Media".equals(name) || "ExposedMedia".equals(name) || !theNode.isValidLink(name, JDFResourceLink.EnumUsage.Input, processUsage))) {
            inOut = JDFResourceLink.EnumUsage.Input;
        }
        String id = this.xjdfToJDFImpl.idMap.get(xjdfRes.getID()).getID();
        JDFResource res = (JDFResource)newRoot.getCreateResourcePool().getChildWithAttribute(null, "ID", null, id, 0, true);
        if (res == null) {
            res = theNode.getCreateResource(name, inOut, processUsage);
            if (theNode != newRoot) {
                newRoot.getCreateResourcePool().moveElement(res, null);
            }
            if (inOut != null) {
                JDFResourceLink rl = theNode.getLink(res, inOut);
                rl.setrRef(id);
                res.removeAttribute("Usage");
                VString reslinks = XJDFToJDFConverter.getResLinkAttribs();
                for (String key : reslinks) {
                    if (!res.hasAttribute(key)) continue;
                    rl.moveAttribute(key, res);
                }
            }
            res.setID(id);
        }
        return res;
    }

    public KElement oldwalk(KElement xjdfRes, KElement jdfResource) {
        KElement newPartitionElement;
        JDFNode theNode = this.xjdfToJDFImpl.currentJDFNode == null ? ((JDFElement)jdfResource).getParentJDF() : this.xjdfToJDFImpl.currentJDFNode;
        JDFPart part = (JDFPart)xjdfRes.getElement("Part");
        JDFAttributeMap partmap = null;
        JDFNode partialProductNode = null;
        if (part != null) {
            newPartitionElement = this.createPartition(xjdfRes, (JDFResource)jdfResource, part, theNode);
            partmap = part.getPartMap();
            String productPart = partmap == null ? null : StringUtil.getNonEmpty(partmap.get("ProductPart"));
            partialProductNode = productPart == null ? null : theNode.getChildJDFNode(productPart, false);
        } else if (xjdfRes.getPreviousSiblingElement(xjdfRes.getNodeName(), null) != null) {
            newPartitionElement = theNode.getJDFRoot().addResource(jdfResource.getLocalName(), null);
            newPartitionElement.copyAttribute("ID", xjdfRes);
        } else {
            newPartitionElement = jdfResource;
        }
        if (newPartitionElement == null) {
            return null;
        }
        JDFAttributeMap map = this.getResMap(xjdfRes);
        if (newPartitionElement instanceof JDFResource) {
            JDFResource newPartition = (JDFResource)newPartitionElement;
            JDFResourceLink rl = theNode.getLink(newPartition, null);
            rl = this.ensureLink(partialProductNode, newPartition, rl);
            this.handleAmountPool(xjdfRes, partmap, map, rl);
        }
        newPartitionElement.setAttributes(map);
        return newPartitionElement;
    }

    private JDFAttributeMap getResMap(KElement xjdfRes) {
        JDFAttributeMap map = xjdfRes.getAttributeMap();
        map.remove("ID");
        map.remove("PartIDKeys");
        return map;
    }

    private void handleAmountPool(KElement xjdfRes, JDFAttributeMap partmap, JDFAttributeMap map, JDFResourceLink rl) {
        KElement ap = xjdfRes.getElement("AmountPool");
        if (ap != null) {
            JDFAmountPool newAmountPool = rl.getCreateAmountPool();
            Vector<JDFPartAmount> vpa = ap.getChildrenByClass(JDFPartAmount.class, false, 0);
            for (JDFPartAmount pa : vpa) {
                this.xjdfToJDFImpl.walkTree(pa, newAmountPool);
            }
            ap.deleteNode();
        }
        this.xjdfToJDFImpl.moveAmountsToLink(partmap, map, rl);
    }

    private JDFResourceLink ensureLink(JDFNode partialProductNode, JDFResource newPartition, JDFResourceLink rl) {
        if (partialProductNode != null) {
            JDFResourceLink.EnumUsage newUsage;
            JDFResourceLink rlpart = partialProductNode.getLink(newPartition, null);
            JDFResourceLink.EnumUsage enumUsage = newUsage = rl == null ? null : rl.getUsage();
            if (rlpart == null && newUsage != null) {
                rlpart = partialProductNode.ensureLink(newPartition, newUsage, null);
            }
            if (rlpart != null) {
                rl = rlpart;
            }
        }
        return rl;
    }

    protected KElement createPartition(KElement xjdfRes, JDFResource jdfRes, JDFPart part, JDFNode theNode) {
        VJDFAttributeMap partMapVector;
        if (part == null) {
            return jdfRes;
        }
        JDFAttributeMap partMap = this.getPartMap(part);
        JDFResource rPart = jdfRes.getCreatePartition(partMap, JDFPart.guessPartIDKeys(partMap));
        JDFResourceLink rll = theNode.getLink(jdfRes, null);
        VJDFAttributeMap vJDFAttributeMap = partMapVector = rll != null ? rll.getPartMapVector() : null;
        if (!(rll == null || partMapVector != null && partMapVector.contains(partMap))) {
            rll.appendPart().setPartMap(partMap);
        }
        return rPart;
    }

    JDFAttributeMap getPartMap(JDFPart part) {
        JDFAttributeMap p;
        JDFAttributeMap jDFAttributeMap = p = part == null ? null : part.getPartMap();
        if (p != null) {
            String sheetName = p.get("SheetName");
            String signatureName = p.get("SignatureName");
            if (StringUtil.getNonEmpty(sheetName) != null && StringUtil.getNonEmpty(signatureName) == null) {
                signatureName = "Sig_" + sheetName;
                p.put("SignatureName", signatureName);
                part.setSignatureName(signatureName);
            }
            p.remove("ProductPart");
            p.remove("ProcessType");
        }
        return p;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && PartitionHelper.isAsset(toCheck);
    }
}

